/*
 * Decompiled with CFR 0.152.
 */
package theGhastModding.planetGen.generators;

import edu.cornell.lassp.houle.RngPack.RanMT;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import theGhastModding.planetGen.noise.NoiseConfig;
import theGhastModding.planetGen.noise.OctaveNoise3D;
import theGhastModding.planetGen.utils.NoiseUtils;
import theGhastModding.planetGen.utils.NoisemapGenerator;

public class NewGasGiantBase {
    public static void main(String[] args) {
        try {
            int r1 = 140;
            int g1 = 209;
            int b1 = 246;
            int r2 = 57;
            int g2 = 168;
            int b2 = 227;
            OctaveNoise3D noise = new OctaveNoise3D(20, 20, 20, 12, 2.0, 0.6);
            noise.initialize(new RanMT());
            NoiseConfig nc = new NoiseConfig(noise, false, 1.5, 1.0, 0.5, 0.125, 0.0);
            BufferedImage img = new BufferedImage(1920, 960, 1);
            int bands = 4;
            int i = 0;
            while (i < img.getHeight()) {
                double x = (double)i * (double)bands / (double)img.getHeight();
                double y = 0.5 * (Math.sin(x * 2.0 * Math.PI) + 1.0);
                int j = 0;
                while (j < img.getWidth()) {
                    double val = NoiseUtils.sampleSpherableNoise(j, i, img.getWidth(), img.getHeight(), nc);
                    val += 0.5;
                    val = Math.max(0.0, Math.min(1.0, val));
                    double y2 = y * val;
                    int r = (int)(y2 * (double)r2 + (1.0 - y2) * (double)r1);
                    int g = (int)(y2 * (double)g2 + (1.0 - y2) * (double)g1);
                    int b = (int)(y2 * (double)b2 + (1.0 - y2) * (double)b1);
                    r = Math.min(255, Math.max(0, r));
                    g = Math.min(255, Math.max(0, g));
                    b = Math.min(255, Math.max(0, b));
                    img.setRGB(j, i, b | g << 8 | r << 16);
                    ++j;
                }
                ++i;
            }
            ImageIO.write((RenderedImage)img, "png", new File("gasgiant-input.png"));
        }
        catch (Exception e) {
            System.err.println("Error: ");
            e.printStackTrace();
            System.exit(1);
        }
        NoisemapGenerator.cleanUp();
    }
}

