/*
 * Decompiled with CFR 0.152.
 */
package theGhastModding.planetGen.generators;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import theGhastModding.planetGen.utils.NoisemapGenerator;

public class SepEmissives {
    public static void main(String[] args) {
        try {
            int j;
            BufferedImage in = ImageIO.read(new File("mercador.png"));
            BufferedImage out = new BufferedImage(in.getWidth(), in.getHeight(), 1);
            BufferedImage emissives = new BufferedImage(in.getWidth(), in.getHeight(), 2);
            double size = 0.2;
            int res = in.getWidth();
            int i = 0;
            while (i < res) {
                j = 0;
                while (j < res) {
                    double x = (double)i / (double)res - 0.5;
                    double z = (double)j / (double)res - 0.5;
                    if (SepEmissives.isInsideHexagon(x, z)) {
                        double[] latlong = SepEmissives.latlong(x *= size, 1.0, z *= size);
                        int imgX = (int)((latlong[1] + 180.0) / 360.0 * (double)in.getWidth());
                        int imgY = (int)(latlong[0] / 180.0 * (double)in.getHeight());
                        if (imgX >= 0 && imgY >= 0 && (out.getRGB(imgX, imgY) & 0xFFFFFF) == 0) {
                            int rgb = in.getRGB(imgX, imgY);
                            int r = rgb >> 16 & 0xFF;
                            int g = rgb >> 8 & 0xFF;
                            int b = rgb >> 0 & 0xFF;
                            r = (int)((double)r * 0.7);
                            g = (int)((double)g * 0.7);
                            b = (int)((double)b * 0.7);
                            if (r > 255) {
                                r = 255;
                            }
                            if (g > 255) {
                                g = 255;
                            }
                            if (b > 255) {
                                b = 255;
                            }
                            out.setRGB(imgX, imgY, b | g << 8 | r << 16);
                        }
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < 90) {
                j = 1;
                while (j < in.getWidth()) {
                    if ((out.getRGB(j, i) & 0xFFFFFF) == 0) {
                        out.setRGB(j, i, out.getRGB(j - 1, i));
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < in.getWidth()) {
                j = 0;
                while (j < in.getHeight()) {
                    if ((out.getRGB(i, j) & 0xFFFFFF) == 0) {
                        int rgb = in.getRGB(i, j);
                        int r = rgb >> 16 & 0xFF;
                        int g = rgb >> 8 & 0xFF;
                        int b = rgb >> 0 & 0xFF;
                        float brightness = Color.RGBtoHSB(r, g, b, null)[2];
                        double emAlpha = brightness;
                        int a = (int)(emAlpha * 255.0);
                        a = Math.max(0, Math.min(255, a));
                        emissives.setRGB(i, j, 0xFFFFFF | a << 24);
                        double mul = Math.max(0.0, Math.min(1.0, 1.0 - emAlpha + 0.1));
                        if (mul >= 0.95) {
                            out.setRGB(i, j, b | g << 8 | r << 16);
                        } else {
                            r = (int)((double)r * mul + (1.0 - mul) * 115.0);
                            g = (int)((double)g * mul + (1.0 - mul) * 63.0);
                            b = (int)((double)b * mul + (1.0 - mul) * 75.0);
                        }
                        out.setRGB(i, j, b | g << 8 | r << 16);
                    }
                    ++j;
                }
                ++i;
            }
            ImageIO.write((RenderedImage)out, "png", new File("mercador_fixed.png"));
            ImageIO.write((RenderedImage)emissives, "png", new File("emissives.png"));
        }
        catch (Exception e) {
            System.err.println("Error: ");
            e.printStackTrace();
            System.exit(1);
        }
        NoisemapGenerator.cleanUp();
    }

    private static boolean isInsideHexagon(double x, double y) {
        return Math.abs(y) < Math.sqrt(3.0) * Math.min(0.5 - Math.abs(x), 0.25);
    }

    public static double[] latlong(double x, double y, double z) {
        double dist = Math.sqrt(x * x + y * y + z * z);
        double latitude = Math.acos(y /= dist) * 57.29577951308232;
        double longitude = (270.0 + Math.atan2(x /= dist, z /= dist) * 180.0 / Math.PI) % 360.0 - 180.0;
        return new double[]{latitude, longitude};
    }
}

