/*
 * Decompiled with CFR 0.152.
 */
package theGhastModding.planetGen.noise;

import java.util.Random;
import theGhastModding.planetGen.noise.NoiseFunction;
import theGhastModding.planetGen.noise.PerlinNoise2D;

public class OctaveNoise2D
extends NoiseFunction {
    private PerlinNoise2D noise;
    private double persistence;
    private double lacunarity;
    private int octaves;

    public OctaveNoise2D(int width, int height, int octaves, double lacunarity, double persistence) {
        super(width, height, 1);
        this.noise = new PerlinNoise2D(width * octaves, height * octaves);
        this.persistence = persistence;
        this.lacunarity = lacunarity;
        this.octaves = octaves;
    }

    @Override
    public void initialize(Random rng) {
        this.noise.initialize(rng);
    }

    @Override
    public void cleanUp() {
        this.noise.cleanUp();
    }

    @Override
    public double sample(double x, double y, double z) {
        if (x < 0.0) {
            x += 2.147483647E9;
        }
        if (y < 0.0) {
            y += 2.147483647E9;
        }
        double finalRes = 0.0;
        double max = 0.0;
        double currFreq = 1.0;
        double currSc = 1.0;
        int i = 0;
        while (i < this.octaves) {
            finalRes += this.noise.sample(x * currFreq, y * currFreq, 0.0) * currSc;
            max += currSc;
            currFreq *= this.lacunarity;
            currSc *= this.persistence;
            ++i;
        }
        return finalRes / max;
    }
}

