/*
 * Decompiled with CFR 0.152.
 */
package theGhastModding.planetGen.noise;

import java.util.Random;
import theGhastModding.planetGen.noise.NoiseFunction;
import theGhastModding.planetGen.noise.PerlinNoise3D;

public class OctaveNoise3D
extends NoiseFunction {
    private PerlinNoise3D noise;
    private double persistence;
    private double lacunarity;
    private int octaves;

    public OctaveNoise3D(int width, int height, int depth, int octaves, double lacunarity, double persistence) {
        super(width, height, depth);
        this.noise = new PerlinNoise3D(width * octaves, height * octaves, depth * octaves);
        this.persistence = persistence;
        this.lacunarity = lacunarity;
        this.octaves = octaves;
    }

    @Override
    public void initialize(Random rng) {
        this.noise.initialize(rng);
    }

    @Override
    public void cleanUp() {
        this.noise.cleanUp();
    }

    @Override
    public double sample(double x, double y, double z) {
        if (x < 0.0) {
            x += 2.147483647E9;
        }
        if (y < 0.0) {
            y += 2.147483647E9;
        }
        if (z < 0.0) {
            z += 2.147483647E9;
        }
        double finalRes = 0.0;
        double max = 0.0;
        double currFreq = 1.0;
        double currSc = 1.0;
        int i = 0;
        while (i < this.octaves) {
            finalRes += this.noise.sample(x * currFreq, y * currFreq, z * currFreq) * currSc;
            max += currSc;
            currFreq *= this.lacunarity;
            currSc *= this.persistence;
            ++i;
        }
        return finalRes / max;
    }
}

