/*
 * Decompiled with CFR 0.152.
 */
package theGhastModding.planetGen.noise;

import java.util.Random;
import theGhastModding.planetGen.noise.NoiseFunction4D;
import theGhastModding.planetGen.noise.PerlinNoise4D;

public class OctaveNoise4D
extends NoiseFunction4D {
    private PerlinNoise4D noise;
    private double persistence;
    private double lacunarity;
    private int octaves;

    public OctaveNoise4D(Random rng, int width, int height, int depth, int trength, int octaves, double persistence, double lacunarity) {
        super(width, height, depth, trength);
        this.noise = new PerlinNoise4D(rng, width + octaves, height * octaves, depth * octaves, trength * octaves);
        this.persistence = persistence;
        this.lacunarity = lacunarity;
        this.octaves = octaves;
    }

    @Override
    public double sample(double x, double y, double z, double w) {
        if (x < 0.0) {
            x += 2.147483647E9;
        }
        if (y < 0.0) {
            y += 2.147483647E9;
        }
        if (z < 0.0) {
            z += 2.147483647E9;
        }
        if (w < 0.0) {
            w += 2.147483647E9;
        }
        double finalRes = 0.0;
        double max = 0.0;
        double currFreq = 1.0;
        double currSc = 1.0;
        int i = 0;
        while (i < this.octaves) {
            finalRes += this.noise.sample(x * currFreq, y * currFreq, z * currFreq, w * currFreq) * currSc;
            max += currSc;
            currFreq *= this.persistence;
            currSc *= this.lacunarity;
            ++i;
        }
        return finalRes / max;
    }
}

