/*
 * Decompiled with CFR 0.152.
 */
package theGhastModding.planetGen.noise;

import java.util.Random;
import theGhastModding.planetGen.noise.NoiseFunction;
import theGhastModding.planetGen.noise.WorleyNoise;

public class OctaveWorley
extends NoiseFunction {
    private WorleyNoise noise;
    private double persistence;
    private double lacunarity;
    private int octaves;

    public OctaveWorley(int width, int height, int depth, int octaves, double lacunarity, double persistence) {
        super(width, height, depth);
        this.noise = new WorleyNoise(width * octaves, height * octaves, depth * octaves);
        this.persistence = persistence;
        this.lacunarity = lacunarity;
        this.octaves = octaves;
    }

    @Override
    public void initialize(Random rng) {
        this.noise.initialize(rng);
    }

    @Override
    public void cleanUp() {
        this.noise.cleanUp();
    }

    @Override
    public double sample(double x, double y, double z) {
        double finalRes = 0.0;
        double max = 0.0;
        double currFreq = 1.0;
        double currSc = 1.0;
        int i = 0;
        while (i < this.octaves) {
            finalRes += this.noise.sample(x * currFreq, y * currFreq, z * currFreq) * currSc;
            max += currSc;
            currFreq *= this.lacunarity;
            currSc *= this.persistence;
            ++i;
        }
        return finalRes / max;
    }
}

