/*
 * Decompiled with CFR 0.152.
 */
package theGhastModding.planetGen.noise;

import java.util.Random;
import theGhastModding.planetGen.noise.NoiseFunction;

public class PerlinNoise2D
extends NoiseFunction {
    private double[][][] noiseMap;

    public PerlinNoise2D(int width, int height) {
        super(width, height, 1);
    }

    @Override
    public void initialize(Random rng) {
        if (this.noiseMap == null) {
            this.noiseMap = new double[this.width + 1][this.height + 1][2];
        }
        int i = 0;
        while (i < this.width + 1) {
            int j = 0;
            while (j < this.height + 1) {
                double d1 = rng.nextDouble() * 2.0 - 1.0;
                double d2 = rng.nextDouble() * 2.0 - 1.0;
                double length = Math.sqrt(d1 * d1 + d2 * d2);
                this.noiseMap[i][j][0] = d1 / length;
                this.noiseMap[i][j][1] = d2 / length;
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void cleanUp() {
        this.noiseMap = null;
        System.gc();
    }

    private static double lerp(double a0, double a1, double w) {
        return a0 + w * (a1 - a0);
    }

    private static double weight(double x) {
        return 3.0 * (x * x) - 2.0 * (x * x * x);
    }

    @Override
    public double sample(double x, double y, double z) {
        int nodex = (int)x;
        int nodey = (int)y;
        double sx = x - (double)nodex;
        double sy = y - (double)nodey;
        double wx = PerlinNoise2D.weight(sx);
        double wy = PerlinNoise2D.weight(sy);
        int nodex1 = (nodex %= this.width + 1) + 1;
        int nodey1 = (nodey %= this.height + 1) + 1;
        double dot0 = sx * this.noiseMap[nodex][nodey][0] + sy * this.noiseMap[nodex][nodey][1];
        double dot1 = (sx - 1.0) * this.noiseMap[nodex1 %= this.width + 1][nodey][0] + sy * this.noiseMap[nodex1][nodey][1];
        double dot2 = sx * this.noiseMap[nodex][nodey1 %= this.height + 1][0] + (sy - 1.0) * this.noiseMap[nodex][nodey1][1];
        double dot3 = (sx - 1.0) * this.noiseMap[nodex1][nodey1][0] + (sy - 1.0) * this.noiseMap[nodex1][nodey1][1];
        double ix0 = PerlinNoise2D.lerp(dot0, dot1, wx);
        double ix1 = PerlinNoise2D.lerp(dot2, dot3, wx);
        return PerlinNoise2D.lerp(ix0, ix1, wy);
    }
}

