/*
 * Decompiled with CFR 0.152.
 */
package theGhastModding.planetGen.noise;

import java.util.Random;
import theGhastModding.planetGen.noise.NoiseFunction;

public class PerlinNoise3D
extends NoiseFunction {
    private double[][][][] noiseMap;

    public PerlinNoise3D(int width, int height, int depth) {
        super(width, height, depth);
    }

    @Override
    public void initialize(Random rng) {
        if (this.noiseMap == null) {
            this.noiseMap = new double[this.width + 1][this.height + 1][this.depth + 1][3];
        }
        int i = 0;
        while (i < this.width + 1) {
            int j = 0;
            while (j < this.height + 1) {
                int k = 0;
                while (k < this.depth + 1) {
                    double d1 = rng.nextDouble() * 2.0 - 1.0;
                    double d2 = rng.nextDouble() * 2.0 - 1.0;
                    double d3 = rng.nextDouble() * 2.0 - 1.0;
                    double dl = Math.sqrt(d1 * d1 + d2 * d2 + d3 * d3);
                    this.noiseMap[i][j][k][0] = d1 /= dl;
                    this.noiseMap[i][j][k][1] = d2 /= dl;
                    this.noiseMap[i][j][k][2] = d3 /= dl;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void cleanUp() {
        this.noiseMap = null;
        System.gc();
    }

    private static double lerp(double a0, double a1, double w) {
        return a0 + w * (a1 - a0);
    }

    private static double weight(double x) {
        return 3.0 * (x * x) - 2.0 * (x * x * x);
    }

    @Override
    public double sample(double x, double y, double z) {
        int nodex = (int)x;
        int nodey = (int)y;
        int nodez = (int)z;
        double sx = x - (double)nodex;
        double sy = y - (double)nodey;
        double sz = z - (double)nodez;
        double wx = PerlinNoise3D.weight(sx);
        double wy = PerlinNoise3D.weight(sy);
        double wz = PerlinNoise3D.weight(sz);
        int nodex1 = (nodex %= this.width + 1) + 1;
        int nodey1 = (nodey %= this.height + 1) + 1;
        int nodez1 = (nodez %= this.depth + 1) + 1;
        double dot0 = sx * this.noiseMap[nodex][nodey][nodez][0] + sy * this.noiseMap[nodex][nodey][nodez][1] + sz * this.noiseMap[nodex][nodey][nodez][2];
        double dot1 = (sx - 1.0) * this.noiseMap[nodex1 %= this.width + 1][nodey][nodez][0] + sy * this.noiseMap[nodex1][nodey][nodez][1] + sz * this.noiseMap[nodex1][nodey][nodez][2];
        double dot2 = sx * this.noiseMap[nodex][nodey1 %= this.height + 1][nodez][0] + (sy - 1.0) * this.noiseMap[nodex][nodey1][nodez][1] + sz * this.noiseMap[nodex][nodey1][nodez][2];
        double dot3 = (sx - 1.0) * this.noiseMap[nodex1][nodey1][nodez][0] + (sy - 1.0) * this.noiseMap[nodex1][nodey1][nodez][1] + sz * this.noiseMap[nodex1][nodey1][nodez][2];
        double dot4 = sx * this.noiseMap[nodex][nodey][nodez1 %= this.depth + 1][0] + sy * this.noiseMap[nodex][nodey][nodez1][1] + (sz - 1.0) * this.noiseMap[nodex][nodey][nodez1][2];
        double dot5 = (sx - 1.0) * this.noiseMap[nodex1][nodey][nodez1][0] + sy * this.noiseMap[nodex1][nodey][nodez1][1] + (sz - 1.0) * this.noiseMap[nodex1][nodey][nodez1][2];
        double dot6 = sx * this.noiseMap[nodex][nodey1][nodez1][0] + (sy - 1.0) * this.noiseMap[nodex][nodey1][nodez1][1] + (sz - 1.0) * this.noiseMap[nodex][nodey1][nodez1][2];
        double dot7 = (sx - 1.0) * this.noiseMap[nodex1][nodey1][nodez1][0] + (sy - 1.0) * this.noiseMap[nodex1][nodey1][nodez1][1] + (sz - 1.0) * this.noiseMap[nodex1][nodey1][nodez1][2];
        double ix0 = PerlinNoise3D.lerp(dot0, dot1, wx);
        double ix1 = PerlinNoise3D.lerp(dot2, dot3, wx);
        double iy0 = PerlinNoise3D.lerp(ix0, ix1, wy);
        double ix2 = PerlinNoise3D.lerp(dot4, dot5, wx);
        double ix3 = PerlinNoise3D.lerp(dot6, dot7, wx);
        double iy1 = PerlinNoise3D.lerp(ix2, ix3, wy);
        return PerlinNoise3D.lerp(iy0, iy1, wz);
    }
}

