/*
 * Decompiled with CFR 0.152.
 */
package theGhastModding.planetGen.noise;

import java.util.Random;
import theGhastModding.planetGen.noise.NoiseFunction4D;

public class PerlinNoise4D
extends NoiseFunction4D {
    private double[][][][][] noiseMap;

    public PerlinNoise4D(Random rng, int width, int height, int depth, int trength) {
        super(width, height, depth, trength);
        this.noiseMap = new double[width + 1][height + 1][depth + 1][trength + 1][4];
        int i = 0;
        while (i < width + 1) {
            int j = 0;
            while (j < height + 1) {
                int k = 0;
                while (k < depth + 1) {
                    int l = 0;
                    while (l < trength + 1) {
                        this.noiseMap[i][j][k][l][0] = rng.nextDouble() * 2.0 - 1.0;
                        this.noiseMap[i][j][k][l][1] = rng.nextDouble() * 2.0 - 1.0;
                        this.noiseMap[i][j][k][l][2] = rng.nextDouble() * 2.0 - 1.0;
                        this.noiseMap[i][j][k][l][3] = rng.nextDouble() * 2.0 - 1.0;
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    private static double lerp(double a0, double a1, double w) {
        return a0 + w * (a1 - a0);
    }

    private static double weight(double x) {
        return 3.0 * (x * x) - 2.0 * (x * x * x);
    }

    @Override
    public double sample(double x, double y, double z, double w) {
        int nodex = (int)x;
        int nodey = (int)y;
        int nodez = (int)z;
        int nodew = (int)w;
        double sx = x - (double)nodex;
        double sy = y - (double)nodey;
        double sz = z - (double)nodez;
        double sw = w - (double)nodew;
        double wx = PerlinNoise4D.weight(sx);
        double wy = PerlinNoise4D.weight(sy);
        double wz = PerlinNoise4D.weight(sz);
        double ww = PerlinNoise4D.weight(sw);
        int nodex1 = (nodex %= this.width + 1) + 1;
        int nodey1 = (nodey %= this.height + 1) + 1;
        int nodez1 = (nodez %= this.depth + 1) + 1;
        int nodew1 = (nodew %= this.trength + 1) + 1;
        nodez1 %= this.depth + 1;
        nodew1 %= this.trength + 1;
        double dot0 = sx * this.noiseMap[nodex][nodey][nodez][nodew][0] + sy * this.noiseMap[nodex][nodey][nodez][nodew][1] + sz * this.noiseMap[nodex][nodey][nodez][nodew][2] + sw * this.noiseMap[nodex][nodey][nodez][nodew][3];
        double dot1 = (sx - 1.0) * this.noiseMap[nodex1 %= this.width + 1][nodey][nodez][nodew][0] + sy * this.noiseMap[nodex1][nodey][nodez][nodew][1] + sz * this.noiseMap[nodex1][nodey][nodez][nodew][2] + sw * this.noiseMap[nodex1][nodey][nodez][nodew][3];
        double dot2 = sx * this.noiseMap[nodex][nodey1 %= this.height + 1][nodez][nodew][0] + (sy - 1.0) * this.noiseMap[nodex][nodey1][nodez][nodew][1] + sz * this.noiseMap[nodex][nodey1][nodez][nodew][2] + sw * this.noiseMap[nodex][nodey1][nodez][nodew][3];
        double dot3 = (sx - 1.0) * this.noiseMap[nodex1][nodey1][nodez][nodew][0] + (sy - 1.0) * this.noiseMap[nodex1][nodey1][nodez][nodew][1] + sz * this.noiseMap[nodex1][nodey1][nodez][nodew][2] + sw * this.noiseMap[nodex1][nodey1][nodez][nodew][3];
        double dot4 = sx * this.noiseMap[nodex][nodey][nodez1][nodew][0] + sy * this.noiseMap[nodex][nodey][nodez1][nodew][1] + (sz - 1.0) * this.noiseMap[nodex][nodey][nodez1][nodew][2] + sw * this.noiseMap[nodex][nodey][nodez1][nodew][3];
        double dot5 = (sx - 1.0) * this.noiseMap[nodex1][nodey][nodez1][nodew][0] + sy * this.noiseMap[nodex1][nodey][nodez1][nodew][1] + (sz - 1.0) * this.noiseMap[nodex1][nodey][nodez1][nodew][2] + sw * this.noiseMap[nodex1][nodey][nodez1][nodew][3];
        double dot6 = sx * this.noiseMap[nodex][nodey1][nodez1][nodew][0] + (sy - 1.0) * this.noiseMap[nodex][nodey1][nodez1][nodew][1] + (sz - 1.0) * this.noiseMap[nodex][nodey1][nodez1][nodew][2] + sw * this.noiseMap[nodex][nodey1][nodez1][nodew][3];
        double dot7 = (sx - 1.0) * this.noiseMap[nodex1][nodey1][nodez1][nodew][0] + (sy - 1.0) * this.noiseMap[nodex1][nodey1][nodez1][nodew][1] + (sz - 1.0) * this.noiseMap[nodex1][nodey1][nodez1][nodew][2] + sw * this.noiseMap[nodex1][nodey1][nodez1][nodew][3];
        double dot8 = sx * this.noiseMap[nodex][nodey][nodez][nodew1][0] + sy * this.noiseMap[nodex][nodey][nodez][nodew1][1] + sz * this.noiseMap[nodex][nodey][nodez][nodew1][2] + (sw - 1.0) * this.noiseMap[nodex][nodey][nodez][nodew1][3];
        double dot9 = (sx - 1.0) * this.noiseMap[nodex1][nodey][nodez][nodew1][0] + sy * this.noiseMap[nodex1][nodey][nodez][nodew1][1] + sz * this.noiseMap[nodex1][nodey][nodez][nodew1][2] + (sw - 1.0) * this.noiseMap[nodex1][nodey][nodez][nodew1][3];
        double dot10 = sx * this.noiseMap[nodex][nodey1][nodez][nodew1][0] + (sy - 1.0) * this.noiseMap[nodex][nodey1][nodez][nodew1][1] + sz * this.noiseMap[nodex][nodey1][nodez][nodew1][2] + (sw - 1.0) * this.noiseMap[nodex][nodey1][nodez][nodew1][3];
        double dot11 = (sx - 1.0) * this.noiseMap[nodex1][nodey1][nodez][nodew1][0] + (sy - 1.0) * this.noiseMap[nodex1][nodey1][nodez][nodew1][1] + sz * this.noiseMap[nodex1][nodey1][nodez][nodew1][2] + (sw - 1.0) * this.noiseMap[nodex1][nodey1][nodez][nodew1][3];
        double dot12 = sx * this.noiseMap[nodex][nodey][nodez1][nodew1][0] + sy * this.noiseMap[nodex][nodey][nodez1][nodew1][1] + (sz - 1.0) * this.noiseMap[nodex][nodey][nodez1][nodew1][2] + (sw - 1.0) * this.noiseMap[nodex][nodey][nodez1][nodew1][3];
        double dot13 = (sx - 1.0) * this.noiseMap[nodex1][nodey][nodez1][nodew1][0] + sy * this.noiseMap[nodex1][nodey][nodez1][nodew1][1] + (sz - 1.0) * this.noiseMap[nodex1][nodey][nodez1][nodew1][2] + (sw - 1.0) * this.noiseMap[nodex1][nodey][nodez1][nodew1][3];
        double dot14 = sx * this.noiseMap[nodex][nodey1][nodez1][nodew1][0] + (sy - 1.0) * this.noiseMap[nodex][nodey1][nodez1][nodew1][1] + (sz - 1.0) * this.noiseMap[nodex][nodey1][nodez1][nodew1][2] + (sw - 1.0) * this.noiseMap[nodex][nodey1][nodez1][nodew1][3];
        double dot15 = (sx - 1.0) * this.noiseMap[nodex1][nodey1][nodez1][nodew1][0] + (sy - 1.0) * this.noiseMap[nodex1][nodey1][nodez1][nodew1][1] + (sz - 1.0) * this.noiseMap[nodex1][nodey1][nodez1][nodew1][2] + (sw - 1.0) * this.noiseMap[nodex1][nodey1][nodez1][nodew1][3];
        double ix0 = PerlinNoise4D.lerp(dot0, dot1, wx);
        double ix1 = PerlinNoise4D.lerp(dot2, dot3, wx);
        double iy0 = PerlinNoise4D.lerp(ix0, ix1, wy);
        double ix2 = PerlinNoise4D.lerp(dot4, dot5, wx);
        double ix3 = PerlinNoise4D.lerp(dot6, dot7, wx);
        double iy1 = PerlinNoise4D.lerp(ix2, ix3, wy);
        double ix4 = PerlinNoise4D.lerp(dot8, dot9, wx);
        double ix5 = PerlinNoise4D.lerp(dot10, dot11, wx);
        double iy2 = PerlinNoise4D.lerp(ix4, ix5, wy);
        double ix6 = PerlinNoise4D.lerp(dot12, dot13, wx);
        double ix7 = PerlinNoise4D.lerp(dot14, dot15, wx);
        double iy3 = PerlinNoise4D.lerp(ix6, ix7, wy);
        double iz0 = PerlinNoise4D.lerp(iy0, iy1, wz);
        double iz1 = PerlinNoise4D.lerp(iy2, iy3, wz);
        return PerlinNoise4D.lerp(iz0, iz1, ww);
    }
}

