/*
 * Decompiled with CFR 0.152.
 */
package theGhastModding.planetGen.noise;

import java.util.Random;
import theGhastModding.planetGen.noise.NoiseFunction;

public class WorleyNoise
extends NoiseFunction {
    private double[][] points;

    public WorleyNoise(int width, int height, int depth) {
        super(width, height, depth);
    }

    @Override
    public void initialize(Random rng) {
        if (this.points == null) {
            this.points = new double[this.width * this.height * this.depth][3];
        }
        int i = 0;
        while (i < this.width) {
            int j = 0;
            while (j < this.height) {
                int k = 0;
                while (k < this.depth) {
                    this.points[k * (this.width * this.height) + j * this.width + i][0] = rng.nextDouble();
                    this.points[k * (this.width * this.height) + j * this.width + i][1] = rng.nextDouble();
                    this.points[k * (this.width * this.height) + j * this.width + i][2] = rng.nextDouble();
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void cleanUp() {
        this.points = null;
        System.gc();
    }

    @Override
    public double sample(double x, double y, double z) {
        int cellx = (int)x % this.width;
        int celly = (int)y % this.height;
        int cellz = (int)z % this.depth;
        if (cellx < 0) {
            cellx = this.width + cellx;
        }
        if (celly < 0) {
            celly = this.height + celly;
        }
        if (cellz < 0) {
            cellz = this.depth + cellz;
        }
        double smallestDist = 1000.0;
        int i = 0;
        while (i < 27) {
            double diffz;
            double diffy;
            double[] cellPoint;
            double diffx;
            double dist;
            int nCellx = (int)x + i % 3 - 1;
            int nCelly = (int)y + i / 3 % 3 - 1;
            int nCellz = (int)z + i / 9 - 1;
            int nCellx2 = (cellx + i % 3 - 1) % this.width;
            int nCelly2 = (celly + i / 3 % 3 - 1) % this.height;
            int nCellz2 = (cellz + i / 9 - 1) % this.depth;
            if (nCellx2 < 0) {
                nCellx2 = this.width + nCellx2;
            }
            if (nCelly2 < 0) {
                nCelly2 = this.height + nCelly2;
            }
            if (nCellz2 < 0) {
                nCellz2 = this.depth + nCellz2;
            }
            if ((dist = Math.sqrt((diffx = x - ((cellPoint = this.points[nCellz2 * (this.width * this.height) + nCelly2 * this.width + nCellx2])[0] + (double)nCellx)) * diffx + (diffy = y - (cellPoint[1] + (double)nCelly)) * diffy + (diffz = z - (cellPoint[2] + (double)nCellz)) * diffz)) < smallestDist) {
                smallestDist = dist;
            }
            ++i;
        }
        return smallestDist;
    }
}

