/*
 * Decompiled with CFR 0.152.
 */
package theGhastModding.planetGen.smalltests;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Arrays;
import java.util.Random;
import javax.imageio.ImageIO;
import theGhastModding.planetGen.noise.NoiseConfig;
import theGhastModding.planetGen.noise.OctaveNoise3D;
import theGhastModding.planetGen.utils.CraterDistributer;
import theGhastModding.planetGen.utils.CraterGenerator;
import theGhastModding.planetGen.utils.NoisemapGenerator;

public class CraterGeneratorTest {
    public static void main(String[] args) {
        try {
            int col;
            int j;
            double[][] testImg = new double[2048][1024];
            double[][] testCraterMap = new double[2048][1024];
            int i = 0;
            while (i < testImg.length) {
                Arrays.fill(testImg[i], 0.8);
                ++i;
            }
            BufferedImage testRes = new BufferedImage(testImg.length, testImg[0].length, 1);
            Random rng = new Random("fuck".hashCode() << 6);
            int craterCnt = 2048;
            double maxsize = 128.0;
            double minsize = 4.0;
            double maxStrength = 0.6;
            double minStrength = 0.05;
            double flattenedStart = 14.0;
            double flattenedEnd = 28.0;
            CraterGenerator.CraterConfig bowlCraterConfig = new CraterGenerator.CraterConfig(0.0, 0.0, 0.2, 0.4, 1.0, 4.8, -10.0, 0.3, 2.1, 0.1, 0.4, 30.0, 96.0, 1.0);
            CraterGenerator.CraterConfig flattenedCraterConfig = new CraterGenerator.CraterConfig(0.0, 0.0, 0.1, 0.5, 1.0, 4.8, -0.5, 0.35, 6.1, 0.15, 0.75, 30.0, 96.0, 0.9);
            OctaveNoise3D mountainsNoise = new OctaveNoise3D(24, 24, 24, 6, 2.0, 0.5);
            mountainsNoise.initialize(rng);
            NoiseConfig nc = new NoiseConfig(mountainsNoise, true, 1.5, 0.17, 0.6, 0.0, 0.0);
            CraterDistributer.CraterDistributionSettings cds = new CraterDistributer.CraterDistributionSettings(2048, 4.0, 128.0, 0.05, 0.6, 14.0, 28.0, nc, 0.8);
            long startTime = System.currentTimeMillis();
            CraterDistributer.distributeCraters(null, testImg, testCraterMap, bowlCraterConfig, flattenedCraterConfig, cds, 1.0, rng, true);
            System.out.println("Took " + (System.currentTimeMillis() - startTime) / 1000L + "s to generate " + 2048 + " craters.");
            int i2 = 0;
            while (i2 < testImg.length) {
                j = 0;
                while (j < testImg[0].length) {
                    col = (int)(testImg[i2][j] * 255.0);
                    col = Math.max(0, Math.min(255, col));
                    testRes.setRGB(i2, j, col | col << 8 | col << 16);
                    ++j;
                }
                ++i2;
            }
            ImageIO.write((RenderedImage)testRes, "png", new File("craters.png"));
            i2 = 0;
            while (i2 < testCraterMap.length) {
                j = 0;
                while (j < testCraterMap[0].length) {
                    col = (int)(testCraterMap[i2][j] * 255.0);
                    col = Math.max(0, Math.min(255, col));
                    testRes.setRGB(i2, j, col | col << 8 | col << 16);
                    ++j;
                }
                ++i2;
            }
            ImageIO.write((RenderedImage)testRes, "png", new File("crater_map.png"));
        }
        catch (Exception e) {
            System.err.println("Error: ");
            e.printStackTrace();
            System.exit(1);
        }
        NoisemapGenerator.cleanUp();
    }
}

