/*
 * Decompiled with CFR 0.152.
 */
package theGhastModding.planetGen.smalltests;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import theGhastModding.planetGen.utils.MapUtils;

public class TestNormalGenerator {
    public static void main(String[] args) {
        try {
            BufferedImage inImg = ImageIO.read(new File("Esker_Height.png"));
            double[][] hm = new double[inImg.getWidth()][inImg.getHeight()];
            int i = 0;
            while (i < inImg.getWidth()) {
                int j = 0;
                while (j < inImg.getHeight()) {
                    hm[i][j] = (double)(inImg.getRGB(i, j) & 0xFF) / 255.0;
                    ++j;
                }
                ++i;
            }
            BufferedImage normalMap = MapUtils.generateNormalMap(hm, 304000.0, 15200.0, 0.3333);
            ImageIO.write((RenderedImage)normalMap, "png", new File("Esker_Normal_gen.png"));
        }
        catch (Exception e) {
            System.err.println("Error: ");
            e.printStackTrace();
            System.exit(1);
        }
    }
}

