/*
 * Decompiled with CFR 0.152.
 */
package theGhastModding.planetGen.smalltests;

import edu.cornell.lassp.houle.RngPack.RanMT;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import theGhastModding.planetGen.noise.NoiseConfig;
import theGhastModding.planetGen.noise.OctaveWorley;
import theGhastModding.planetGen.utils.NoisemapGenerator;

public class WorleyTest {
    public static void main(String[] args) {
        int j;
        double[][] noisemap = new double[2048][1024];
        BufferedImage res = new BufferedImage(2048, 1024, 1);
        RanMT rng = new RanMT(3528608460342643357L);
        OctaveWorley worley = new OctaveWorley(32, 32, 32, 5, 2.0, 0.5);
        worley.initialize(rng);
        NoiseConfig nc = new NoiseConfig(worley).setIsRidged(false).setNoiseStrength(1.25).setNoiseScale(1.0).setDistortStrength(0.5).setNoiseOffset(0.0);
        System.out.println(-1);
        try {
            NoisemapGenerator.genNoisemap(noisemap, nc, null, 1.0, true);
        }
        catch (Exception e) {
            System.err.println("Error generating noisemap: ");
            e.printStackTrace();
            System.exit(1);
        }
        int i = 0;
        while (i < 2048) {
            j = 0;
            while (j < 1024) {
                noisemap[i][j] = (noisemap[i][j] - 0.5) * 1.25 + 0.625;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < 2048) {
            j = 0;
            while (j < 1024) {
                noisemap[i][j] = Math.max(0.0, Math.min(1.0, noisemap[i][j]));
                int col = (int)(noisemap[i][j] * 255.0);
                res.setRGB(i, j, col | col << 8 | col << 16);
                ++j;
            }
            ++i;
        }
        JOptionPane.showMessageDialog(null, new JLabel(new ImageIcon(res)), "a", 1);
        try {
            ImageIO.write((RenderedImage)res, "png", new File("worley.png"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        NoisemapGenerator.cleanUp();
    }
}

