/*
 * Decompiled with CFR 0.152.
 */
package theGhastModding.planetGen.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import theGhastModding.planetGen.noise.NoiseConfig;
import theGhastModding.planetGen.utils.CraterGenerator;
import theGhastModding.planetGen.utils.GlobalConfiguration;
import theGhastModding.planetGen.utils.ProgressBars;

public class CraterDistributer {
    private static final int maxThreads = GlobalConfiguration.MAX_THREADS;
    private static final DistributionRunner[] distributionRunners = new DistributionRunner[maxThreads];
    private static final ThreadPoolExecutor threadPool;
    private static volatile double[][] mapBuffer;
    private static volatile double[][] craterMapBuffer;
    public static List<CraterInstance> cratersToGenerate;

    static {
        int i = 0;
        while (i < maxThreads) {
            CraterDistributer.distributionRunners[i] = new DistributionRunner(i, maxThreads);
            ++i;
        }
        threadPool = (ThreadPoolExecutor)Executors.newCachedThreadPool();
        mapBuffer = null;
        craterMapBuffer = null;
        cratersToGenerate = new ArrayList<CraterInstance>();
    }

    public static double biasFunction(double x, double bias) {
        double k = 1.0 - bias;
        k = k * k * k;
        return x * k / (x * k - x + 1.0);
    }

    private static double biasedRNG(Random rng, double bias) {
        if (bias <= 1.0E-8) {
            return 0.0;
        }
        return (rng.nextDouble() * 2.0 - 1.0) * bias;
    }

    public static void distributeCraters(boolean[][] distributionMap, double[][] map, double[][] craterMap, CraterGenerator.CraterConfig bowlCraterConfig, CraterGenerator.CraterConfig flattenedCraterConfig, CraterDistributionSettings settings, double planetSizeScale, Random rng, boolean debugProgress) {
        int maxTries = settings.craterCount;
        int tries = 0;
        cratersToGenerate.clear();
        int i = 0;
        while (i < settings.craterCount) {
            boolean shouldPlace;
            double lat = rng.nextDouble() * 160.0 + 10.0;
            double lon = rng.nextDouble() * 360.0;
            boolean bl = shouldPlace = distributionMap == null ? true : distributionMap[(int)(lon / 360.0 * (double)distributionMap.length)][(int)(lat / 180.0 * (double)distributionMap[0].length)];
            if (!shouldPlace) {
                --i;
                if (++tries >= maxTries) {
                    break;
                }
            } else {
                double size = rng.nextDouble();
                size = CraterDistributer.biasFunction(size, settings.distributionBias);
                double cSize = size * (settings.maxsize - settings.minsize);
                cSize += settings.minsize;
                double floorHeight = -1.0;
                double bMul = 1.0;
                double fMul = 0.0;
                if (cSize > settings.flattenedStart) {
                    fMul = Math.min(1.0, (cSize - settings.flattenedStart) / (settings.flattenedEnd - settings.flattenedStart));
                    bMul = 1.0 - fMul;
                }
                floorHeight = fMul * flattenedCraterConfig.floorHeight + bMul * bowlCraterConfig.floorHeight;
                CraterGenerator.CraterConfig finalCraterConfig = new CraterGenerator.CraterConfig();
                finalCraterConfig.setFloorHeight(floorHeight);
                finalCraterConfig.setSize(cSize);
                finalCraterConfig.setCraterStrength(size * (settings.maxStrength - settings.minStrength) + settings.minStrength + CraterDistributer.biasedRNG(rng, settings.craterStrengthRNGBias));
                finalCraterConfig.setP1(bowlCraterConfig.p1 * bMul + flattenedCraterConfig.p1 * fMul + CraterDistributer.biasedRNG(rng, settings.p1RNGBias));
                finalCraterConfig.setP2(bowlCraterConfig.p2 * bMul + flattenedCraterConfig.p2 * fMul + CraterDistributer.biasedRNG(rng, settings.p2RNGBias));
                finalCraterConfig.setPerturbStrength(bowlCraterConfig.perturbStrength * bMul + flattenedCraterConfig.perturbStrength * fMul);
                finalCraterConfig.setPerturbScale(bowlCraterConfig.perturbScale * bMul + flattenedCraterConfig.perturbScale * fMul);
                finalCraterConfig.setEjectaStrength(bowlCraterConfig.ejectaStrength * bMul + flattenedCraterConfig.ejectaStrength * fMul);
                finalCraterConfig.setEjectaStretch(bowlCraterConfig.ejectaStretch * bMul + flattenedCraterConfig.ejectaStretch * fMul);
                finalCraterConfig.setEjectaPerturbStrength(bowlCraterConfig.ejectaPerturbStrength * bMul + flattenedCraterConfig.ejectaPerturbStrength * fMul);
                finalCraterConfig.setEjectaPerturbScale(bowlCraterConfig.ejectaPerturbScale * bMul + flattenedCraterConfig.ejectaPerturbScale * fMul);
                finalCraterConfig.setRingFunctMul(bowlCraterConfig.ringFunctMul * bMul + flattenedCraterConfig.ringFunctMul * fMul + CraterDistributer.biasedRNG(rng, settings.ringFunctRNGBias));
                finalCraterConfig.setFullPeakSize(bowlCraterConfig.fullPeakSize + CraterDistributer.biasedRNG(rng, settings.fullPeakRNGBias));
                finalCraterConfig.setRingThreshold(bowlCraterConfig.ringThreshold);
                cratersToGenerate.add(new CraterInstance(finalCraterConfig, rng.nextLong(), lat - 90.0, lon - 180.0, settings.mountainsNoise));
            }
            ++i;
        }
        if (mapBuffer == null || mapBuffer.length < map.length || mapBuffer[0].length < map[0].length) {
            mapBuffer = new double[map.length][map[0].length];
        }
        if (craterMap != null && (craterMapBuffer == null || craterMapBuffer.length < craterMap.length || craterMapBuffer[0].length < craterMap[0].length)) {
            craterMapBuffer = new double[craterMap.length][craterMap[0].length];
        }
        double oldLatScale = 0.0;
        double oldLonScale = 0.0;
        if (settings.mountainsNoise != null) {
            oldLatScale = settings.mountainsNoise.noiseLatitudeScale;
            oldLonScale = settings.mountainsNoise.noiseLongitudeScale;
            settings.mountainsNoise.noiseLatitudeScale *= planetSizeScale;
            settings.mountainsNoise.noiseLongitudeScale *= planetSizeScale;
        }
        try {
            int i2 = 0;
            while (i2 < map.length) {
                System.arraycopy(map[i2], 0, mapBuffer[i2], 0, mapBuffer[i2].length);
                if (craterMap != null) {
                    System.arraycopy(craterMap[i2], 0, craterMapBuffer[i2], 0, craterMapBuffer[i2].length);
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < maxThreads) {
                distributionRunners[i2].prepare(map, craterMap, mapBuffer, craterMap == null ? null : craterMapBuffer, cratersToGenerate, new CraterGenerator(map.length, map[0].length), map.length, map[0].length, debugProgress && i2 == 0);
                threadPool.submit(distributionRunners[i2]);
                ++i2;
            }
            while (threadPool.getActiveCount() > 0) {
                try {
                    Thread.sleep(240L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            i = 0;
            while (i < map.length) {
                System.arraycopy(mapBuffer[i], 0, map[i], 0, map[i].length);
                if (craterMap != null) {
                    System.arraycopy(craterMapBuffer[i], 0, craterMap[i], 0, craterMap[i].length);
                }
                ++i;
            }
        }
        finally {
            if (settings.mountainsNoise != null) {
                settings.mountainsNoise.noiseLatitudeScale = oldLatScale;
                settings.mountainsNoise.noiseLongitudeScale = oldLonScale;
            }
        }
    }

    public static void cleanUp() {
        threadPool.shutdown();
    }

    public static class CraterDistributionSettings {
        public int craterCount;
        public double minsize;
        public double maxsize;
        public double minStrength;
        public double maxStrength;
        public double flattenedStart;
        public double flattenedEnd;
        public NoiseConfig mountainsNoise;
        public double distributionBias;
        public double ringFunctRNGBias;
        public double p1RNGBias;
        public double p2RNGBias;
        public double craterStrengthRNGBias;
        public double fullPeakRNGBias;

        public CraterDistributionSettings() {
        }

        public CraterDistributionSettings(int craterCount, double minsize, double maxsize, double minStrength, double maxStrength, double flattenedStart, double flattenedEnd, NoiseConfig mountainsNoise, double distributionBias) {
            this.craterCount = craterCount;
            this.minsize = minsize;
            this.maxsize = maxsize;
            this.minStrength = minStrength;
            this.maxStrength = maxStrength;
            this.flattenedStart = flattenedStart;
            this.flattenedEnd = flattenedEnd;
            this.mountainsNoise = mountainsNoise;
            this.distributionBias = distributionBias;
            this.ringFunctRNGBias = 0.0;
            this.p1RNGBias = 0.0;
            this.p2RNGBias = 0.0;
            this.craterStrengthRNGBias = 0.0;
            this.fullPeakRNGBias = 0.0;
        }

        public CraterDistributionSettings setCraterCount(int craterCount) {
            this.craterCount = craterCount;
            return this;
        }

        public CraterDistributionSettings setMinsize(double minsize) {
            this.minsize = minsize;
            return this;
        }

        public CraterDistributionSettings setMaxsize(double maxsize) {
            this.maxsize = maxsize;
            return this;
        }

        public CraterDistributionSettings setMinStrength(double minStrength) {
            this.minStrength = minStrength;
            return this;
        }

        public CraterDistributionSettings setMaxStrength(double maxStrength) {
            this.maxStrength = maxStrength;
            return this;
        }

        public CraterDistributionSettings setFlattenedStart(double flattenedStart) {
            this.flattenedStart = flattenedStart;
            return this;
        }

        public CraterDistributionSettings setFlattenedEnd(double flattenedEnd) {
            this.flattenedEnd = flattenedEnd;
            return this;
        }

        public CraterDistributionSettings setMountainsNoise(NoiseConfig mountainsNoise) {
            this.mountainsNoise = mountainsNoise;
            return this;
        }

        public CraterDistributionSettings setDistributionBias(double distributionBias) {
            this.distributionBias = distributionBias;
            return this;
        }

        public CraterDistributionSettings setRingFunctRNGBias(double ringFunctRNGBias) {
            this.ringFunctRNGBias = ringFunctRNGBias;
            return this;
        }

        public CraterDistributionSettings setP1RNGBias(double p1rngBias) {
            this.p1RNGBias = p1rngBias;
            return this;
        }

        public CraterDistributionSettings setP2RNGBias(double p2rngBias) {
            this.p2RNGBias = p2rngBias;
            return this;
        }

        public CraterDistributionSettings setCraterStrengthRNGBias(double craterStrengthRNGBias) {
            this.craterStrengthRNGBias = craterStrengthRNGBias;
            return this;
        }

        public CraterDistributionSettings setFullPeakRNGBias(double fullPeakRNGBias) {
            this.fullPeakRNGBias = fullPeakRNGBias;
            return this;
        }
    }

    private static class CraterInstance {
        public CraterGenerator.CraterConfig finalCraterConfig;
        public long rngSeed;
        public double latitude;
        public double longitude;
        public NoiseConfig mountainsNoise;

        public CraterInstance(CraterGenerator.CraterConfig finalCraterConfig, long rngSeed, double latitude, double longitude, NoiseConfig mountainsNoise) {
            this.finalCraterConfig = finalCraterConfig;
            this.rngSeed = rngSeed;
            this.latitude = latitude;
            this.longitude = longitude;
            this.mountainsNoise = mountainsNoise;
        }
    }

    private static class DistributionRunner
    implements Runnable {
        private final int indx;
        private final int threadCount;
        private double[][] map;
        private double[][] craterMap;
        private double[][] mapOutput;
        private double[][] craterMapOutput;
        private List<CraterInstance> toGenerate;
        private CraterGenerator generator;
        private boolean debugProgress;
        private int from;
        private int to;

        public DistributionRunner(int indx, int threadCount) {
            this.indx = indx;
            this.threadCount = threadCount;
        }

        public void prepare(double[][] map, double[][] craterMap, double[][] mapOutput, double[][] craterMapOutput, List<CraterInstance> toGenerate, CraterGenerator generator, int width, int height, boolean debugProgress) {
            this.map = map;
            this.craterMap = craterMap;
            this.mapOutput = mapOutput;
            this.craterMapOutput = craterMapOutput;
            this.toGenerate = toGenerate;
            this.generator = generator;
            this.debugProgress = debugProgress;
            this.from = (int)((double)height / (double)this.threadCount * (double)this.indx);
            this.to = this.indx == this.threadCount - 1 ? height : (int)((double)height / (double)this.threadCount * (double)(this.indx + 1));
        }

        @Override
        public void run() {
            if (this.debugProgress) {
                ProgressBars.printBar();
            }
            Random rng = new Random();
            int i = 0;
            while (i < this.toGenerate.size()) {
                if (this.debugProgress) {
                    ProgressBars.printProgress(i, this.toGenerate.size());
                }
                CraterInstance crater = this.toGenerate.get(i);
                rng.setSeed(crater.rngSeed);
                this.generator.genCrater(this.map, this.craterMap, this.mapOutput, this.craterMapOutput, this.from, this.to, crater.latitude, crater.longitude, crater.finalCraterConfig, crater.mountainsNoise, rng);
                ++i;
            }
            if (this.debugProgress) {
                ProgressBars.finishProgress();
            }
        }
    }
}

