/*
 * Decompiled with CFR 0.152.
 */
package theGhastModding.planetGen.utils;

import edu.cornell.lassp.houle.RngPack.RanMT;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.Arrays;
import java.util.Random;
import javax.imageio.ImageIO;
import theGhastModding.planetGen.noise.NoiseConfig;
import theGhastModding.planetGen.noise.OctaveNoise2D;
import theGhastModding.planetGen.noise.OctaveNoise3D;
import theGhastModding.planetGen.noise.PerlinNoise3D;
import theGhastModding.planetGen.utils.CraterDistributer;
import theGhastModding.planetGen.utils.NoiseUtils;
import theGhastModding.planetGen.utils.SphereUtils;

public class CraterGenerator {
    private double[] acosCache;
    private double stride;
    private PerlinNoise3D noise3d;
    private NoiseConfig perturbNoiseConfig;
    private int width;
    private int height;

    public CraterGenerator(int width, int height) {
        this.width = width;
        this.height = height;
        this.noise3d = new PerlinNoise3D(8, 8, 8);
        this.perturbNoiseConfig = new NoiseConfig(this.noise3d);
        double stride = Math.sqrt((double)width * (double)width + (double)height * (double)height) * 8.0 * Math.PI;
        int len = (int)stride;
        this.stride = stride = 1.0 / stride;
        this.acosCache = new double[len + 1];
        int i = 0;
        while (i < len + 1) {
            this.acosCache[i] = Math.acos(stride * (double)i);
            ++i;
        }
    }

    private double getSignCorrectedAcosAt(int indx) {
        if (indx < 0) {
            return 1.5707963267948966 + (1.5707963267948966 - this.acosCache[-indx]);
        }
        return this.acosCache[indx];
    }

    private double internalAcos(double x) {
        int indx;
        int indx2 = indx + ((indx = (int)(x / this.stride)) == this.acosCache.length - 1 ? 0 : 1);
        double d = (x - (double)indx * this.stride) / this.stride;
        return (1.0 - d) * this.getSignCorrectedAcosAt(indx) + d * this.getSignCorrectedAcosAt(indx2);
    }

    public boolean genCrater(double[][] map, double[][] craterMap, int ymin, int ymax, double lat, double lon, CraterConfig cc, NoiseConfig peakNoise, Random rng) {
        return this.genCrater(map, craterMap, map, craterMap, ymin, ymax, lat, lon, cc, peakNoise, rng);
    }

    public boolean genCrater(double[][] baseMap, double[][] baseCraterMap, double[][] map, double[][] craterMap, int ymin, int ymax, double lat, double lon, CraterConfig cc, NoiseConfig peakNoise, Random rng) {
        int i;
        double baseHeight = baseMap[(int)((lon + 180.0) / 360.0 * (double)this.width)][(int)((lat + 90.0) / 180.0 * (double)this.height)];
        double baseHeightCM = craterMap == null ? 0.0 : baseCraterMap[(int)((lon + 180.0) / 360.0 * (double)this.width)][(int)((lat + 90.0) / 180.0 * (double)this.height)];
        double th = cc.craterStrength * 1.1;
        if (cc.floorHeight >= 0.0) {
            return false;
        }
        if (cc.floorHeight > -1.0) {
            th *= Math.abs(cc.floorHeight);
        }
        if (baseHeight < th) {
            return false;
        }
        double s = 1.0 / cc.size;
        double perturbStrength = cc.perturbStrength * cc.size;
        double ejectaPerturbStrength = cc.ejectaPerturbStrength * cc.size;
        double ejectaStretch = 1.0 / cc.ejectaStretch;
        double enddist = -Math.log(1.5259021896696422E-5 / cc.craterStrength) / (s * Math.log(cc.p2)) * Math.max(1.0, (double)this.width / 4096.0);
        this.noise3d.initialize(rng);
        lat %= 180.0;
        lon %= 360.0;
        this.perturbNoiseConfig.setIsRidged(false).setNoiseStrength(perturbStrength).setNoiseScale(cc.perturbScale).setDistortStrength(0.125).setNoiseOffset(0.0);
        double[] noise = new double[this.width * 2 + 1];
        double[] eNoise = new double[this.width * 2 + 1];
        if (perturbStrength <= 0.0 || cc.perturbScale <= 0.0) {
            Arrays.fill(noise, 0.0);
        } else {
            i = 0;
            while (i < this.width * 2 + 1) {
                noise[i] = NoiseUtils.sampleSpherableNoise((double)i / (double)(this.width * 2 + 1) * 24.0, 13.0, 24.0, 24.0, this.perturbNoiseConfig);
                ++i;
            }
        }
        if (ejectaPerturbStrength <= 0.0 || cc.ejectaPerturbScale <= 0.0) {
            Arrays.fill(eNoise, 0.0);
        } else {
            this.perturbNoiseConfig.setNoiseStrength(ejectaPerturbStrength).setNoiseScale(cc.ejectaPerturbScale);
            i = 0;
            while (i < this.width * 2 + 1) {
                eNoise[i] = NoiseUtils.sampleSpherableNoise((double)i / (double)(this.width * 2 + 1) * 24.0, 11.0, 24.0, 24.0, this.perturbNoiseConfig);
                ++i;
            }
        }
        double sinLat = Math.sin(Math.toRadians(lat));
        double cosLat = Math.cos(Math.toRadians(lat));
        double[] diffLongCache = new double[this.width];
        int i2 = 0;
        while (i2 < this.width) {
            double longitude = (double)(i2 - this.width / 2) / ((double)this.width / 2.0) * 180.0;
            diffLongCache[i2] = Math.cos(Math.toRadians(Math.abs(lon - longitude)));
            ++i2;
        }
        int j = ymin;
        while (j < ymax) {
            double latitude = (double)(j - this.height / 2) / ((double)this.height / 2.0) * 90.0;
            double dist = SphereUtils.distance(lat, lon, latitude, lon);
            if (!(Math.abs(dist *= (double)(this.width / 2)) >= enddist)) {
                double sinLatitude = Math.sin(Math.toRadians(latitude));
                double cosLatitude = Math.cos(Math.toRadians(latitude));
                double a = sinLat * sinLatitude;
                int istart = 0;
                int iend = this.width;
                int i3 = istart;
                while (i3 < iend) {
                    double longitude = (double)(i3 - this.width / 2) / ((double)this.width / 2.0) * 180.0;
                    double b = cosLat * cosLatitude * diffLongCache[i3];
                    dist = this.internalAcos(a + b) / Math.PI;
                    double crater_funct_x = dist *= 2048.0;
                    if (!(Math.abs(crater_funct_x) >= enddist)) {
                        double angle = SphereUtils.angleFromCoordinate(lat, lon, latitude, longitude);
                        if (Double.isNaN(angle)) {
                            angle = 0.1;
                        }
                        double h = noise[(int)(angle / 360.0 * (double)this.width * 2.0)];
                        double eh = eNoise[(int)(angle / 360.0 * (double)this.width * 2.0)];
                        double ringFunctMul = 1.0;
                        double[] func = this.craterFunct(crater_funct_x, crater_funct_x + h, crater_funct_x + eh, eh, s, cc.p1, cc.p2, map[i3][j], baseHeight, cc.craterStrength, cc.ejectaStrength, ejectaStretch, ringFunctMul *= cc.ringFunctMul, cc.floorHeight, peakNoise, latitude, longitude, cc.fullPeakSize, cc.ringThreshold, baseHeightCM, craterMap == null ? 0.0 : craterMap[i3][j]);
                        if (craterMap != null) {
                            craterMap[i3][j] = func[1];
                        }
                        map[i3][j] = func[0];
                    }
                    ++i3;
                }
            }
            ++j;
        }
        return true;
    }

    public static double smoothMin(double a, double b, double k) {
        if (k == 0.0) {
            return Math.min(a, b);
        }
        double h = Math.max(0.0, Math.min(1.0, (b - a + k) / (2.0 * k)));
        return a * h + b * (1.0 - h) - k * h * (1.0 - h);
    }

    public double[] craterFunct(double x1, double x2, double ejectaX, double ejectaPerturb, double s, double p1, double p2, double terrainHeight, double baseHeight, double craterStrength, double ejectaStrength, double ejectaStretch, double ringFunctMul, double floorHeight, NoiseConfig peakNoise, double lat, double lon, double fullPeakSize, double ringThreshold, double baseHeightCM, double terrainHeightCM) {
        double rS = 1.0 / s;
        double peak = 0.0;
        if (ejectaStrength > 0.0) {
            if (rS <= ringThreshold) {
                double p = Math.min(1.0, rS / fullPeakSize);
                double x_a = Math.abs(ejectaX * ejectaStretch);
                peak = x_a * (1.0 / p) < Math.PI ? (Math.cos(x_a * (1.0 / p)) + 1.0) * p * ejectaStrength : 0.0;
            } else {
                double ringS = 1.0 / s;
                double rS2 = ringFunctMul / s;
                double m1 = Math.max(0.0, Math.min(1.0, (ringS - 10.0) / 80.0));
                double p = rS2 * ejectaStretch * (0.5 * m1) - Math.max(0.0, 1.0 - Math.min(1.0, (rS2 - 10.0) * 0.1)) * Math.PI;
                double peakX = Math.abs(ejectaX * ejectaStretch) - p;
                double d = peak = ejectaStrength > 0.0 && peakX <= Math.PI && peakX >= -Math.PI ? (Math.cos(peakX) + 1.0) * ejectaStrength : 0.0;
            }
            if (peak >= 1.0E-8) {
                double n = NoiseUtils.sampleSpherableNoise(lon + 180.0, lat + 90.0, 360.0, 180.0, peakNoise);
                peak *= n;
            }
        }
        double absSX = Math.abs(s * x1);
        double bowl = Math.pow(absSX, p1) - 1.0;
        bowl = CraterGenerator.smoothMin(bowl, floorHeight, -0.15);
        double lip = Math.pow(p2, -Math.abs(s * x2));
        return new double[]{CraterGenerator.smoothMin((bowl + peak) * craterStrength + baseHeight, lip * craterStrength + terrainHeight, s < 4.0 ? 0.0 : 0.05), CraterGenerator.smoothMin(bowl + baseHeightCM, lip + terrainHeightCM, s < 4.0 ? 0.0 : 0.05)};
    }

    public static void main(String[] args) {
        try {
            double[][] testImg = new double[4096][2048];
            int i = 0;
            while (i < testImg.length) {
                Arrays.fill(testImg[i], 0.75);
                ++i;
            }
            BufferedImage testRes = new BufferedImage(4096, 2048, 1);
            RanMT rng = new RanMT().seedCompletely();
            OctaveNoise3D mountainsNoise = new OctaveNoise3D(24, 24, 24, 6, 2.0, 0.5);
            mountainsNoise.initialize(rng);
            long startTime = System.currentTimeMillis();
            NoiseConfig nc = new NoiseConfig(mountainsNoise, true, 3.8, 0.17, 0.6, 0.0, 0.0);
            CraterGenerator generator = new CraterGenerator(testImg.length, testImg[0].length);
            CraterConfig cc = new CraterConfig(5.0, 0.3, 0.2, 0.4, 1.0, 4.8, -10.0, 0.25, 4.2, 0.1, 0.4, 30.0, 75.0, 1.0);
            generator.genCrater(testImg, null, 0, testImg[0].length, 0.0, 0.0, cc, nc, rng);
            cc.setSize(15.0);
            generator.genCrater(testImg, null, 0, testImg[0].length, 0.0, 2.5, cc, nc, rng);
            cc.setSize(32.0);
            generator.genCrater(testImg, null, 0, testImg[0].length, 0.0, 7.5, cc, nc, rng);
            cc.setSize(35.0).setEjectaPerturbScale(1.0);
            generator.genCrater(testImg, null, 0, testImg[0].length, 0.0, 17.5, cc, nc, rng);
            cc.setSize(116.0).setEjectaStretch(8.4);
            generator.genCrater(testImg, null, 0, testImg[0].length, 0.0, 37.5, cc, nc, rng);
            System.err.println(System.currentTimeMillis() - startTime);
            int i2 = 0;
            while (i2 < 4096) {
                int j = 0;
                while (j < 2048) {
                    int col = (int)(testImg[i2][j] * 255.0);
                    col = Math.max(0, Math.min(255, col));
                    testRes.setRGB(i2, j, col | col << 8 | col << 16);
                    ++j;
                }
                ++i2;
            }
            ImageIO.write((RenderedImage)testRes, "png", new File("craters.png"));
            testRes = new BufferedImage(225, 50, 1);
            Graphics2D g = (Graphics2D)testRes.getGraphics();
            g.setColor(Color.DARK_GRAY);
            g.fillRect(0, 0, testRes.getWidth(), testRes.getHeight());
            g.setColor(Color.WHITE);
            int i3 = 0;
            while (i3 < 225) {
                double h = CraterDistributer.biasFunction((double)i3 / 255.0, 0.5);
                int h2 = (int)(h * 50.0);
                g.drawLine(i3, 49, i3, 50 - h2 - 1);
                ++i3;
            }
            ImageIO.write((RenderedImage)testRes, "png", new File("crosssection.png"));
            testRes = new BufferedImage(900, 200, 1);
            OctaveNoise2D noise2d = new OctaveNoise2D(4, 4, 4, 0.5, 2.0);
            noise2d.initialize(rng);
            int prevy = Integer.MAX_VALUE;
            g = (Graphics2D)testRes.getGraphics();
            g.setColor(Color.WHITE);
            nc = new NoiseConfig(noise2d, false, 1.0, 0.08333333333333333, 0.25, 0.5, 0.0);
            int i4 = 0;
            while (i4 < testRes.getWidth()) {
                double h = NoiseUtils.sampleSpherableNoise(i4, 450.0, 900.0, 900.0, nc);
                if (!(h < 0.0)) {
                    int y = testRes.getHeight() - (int)(h * (double)testRes.getHeight()) - 1;
                    if (prevy != Integer.MAX_VALUE) {
                        g.drawLine(i4 - 1, prevy, i4, y);
                    }
                    prevy = y;
                }
                ++i4;
            }
            ImageIO.write((RenderedImage)testRes, "png", new File("noise1d.png"));
        }
        catch (Exception e) {
            System.err.println("Error: ");
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static class CraterConfig {
        public double size;
        public double craterStrength;
        public double perturbStrength;
        public double perturbScale;
        public double p1;
        public double p2;
        public double floorHeight;
        public double ejectaStrength;
        public double ejectaStretch;
        public double ejectaPerturbStrength;
        public double ejectaPerturbScale;
        public double fullPeakSize;
        public double ringThreshold;
        public double ringFunctMul;

        public CraterConfig(double size, double craterStrength, double perturbStrength, double perturbScale, double p1, double p2, double floorHeight, double ejectaStrength, double ejectaStretch, double ejectaPerturbStrength, double ejectaPerturbScale, double fullPeakSize, double ringThreshold, double ringFunctMul) {
            this.size = size;
            this.craterStrength = craterStrength;
            this.perturbStrength = perturbStrength;
            this.perturbScale = perturbScale;
            this.p1 = p1;
            this.p2 = p2;
            this.floorHeight = floorHeight;
            this.ejectaStrength = ejectaStrength;
            this.ejectaStretch = ejectaStretch;
            this.ejectaPerturbStrength = ejectaPerturbStrength;
            this.ejectaPerturbScale = ejectaPerturbScale;
            this.fullPeakSize = fullPeakSize;
            this.ringThreshold = ringThreshold;
            this.ringFunctMul = ringFunctMul;
        }

        public CraterConfig() {
            this.size = 0.0;
        }

        public CraterConfig setSize(double size) {
            this.size = size;
            return this;
        }

        public CraterConfig setCraterStrength(double craterStrength) {
            this.craterStrength = craterStrength;
            return this;
        }

        public CraterConfig setPerturbStrength(double perturbStrength) {
            this.perturbStrength = perturbStrength;
            return this;
        }

        public CraterConfig setPerturbScale(double perturbScale) {
            this.perturbScale = perturbScale;
            return this;
        }

        public CraterConfig setP1(double p1) {
            this.p1 = p1;
            return this;
        }

        public CraterConfig setP2(double p2) {
            this.p2 = p2;
            return this;
        }

        public CraterConfig setFloorHeight(double floorHeight) {
            this.floorHeight = floorHeight;
            return this;
        }

        public CraterConfig setEjectaStrength(double ejectaStrength) {
            this.ejectaStrength = ejectaStrength;
            return this;
        }

        public CraterConfig setEjectaStretch(double ejectaStretch) {
            this.ejectaStretch = ejectaStretch;
            return this;
        }

        public CraterConfig setEjectaPerturbStrength(double ejectaPerturbStrength) {
            this.ejectaPerturbStrength = ejectaPerturbStrength;
            return this;
        }

        public CraterConfig setEjectaPerturbScale(double ejectaPerturbScale) {
            this.ejectaPerturbScale = ejectaPerturbScale;
            return this;
        }

        public CraterConfig setFullPeakSize(double fullPeakSize) {
            this.fullPeakSize = fullPeakSize;
            return this;
        }

        public CraterConfig setRingThreshold(double ringThreshold) {
            this.ringThreshold = ringThreshold;
            return this;
        }

        public CraterConfig setRingFunctMul(double ringFunctMul) {
            this.ringFunctMul = ringFunctMul;
            return this;
        }

        public static CraterConfig genBowlOnlyConfig(double size, double craterStrength, double perturbStrength, double perturbScale, double p1, double p2) {
            return new CraterConfig(size, craterStrength, perturbStrength, perturbScale, p1, p2, -10.0, 0.0, 2.1, 0.1, 0.4, 1000000.0, 1000000.0, 1.0);
        }

        public String toString() {
            String s = String.format("Size: %#.4f", this.size);
            s = String.valueOf(s) + String.format("\nStrength: %#.4f", this.craterStrength);
            s = String.valueOf(s) + String.format("\nPerturb Strength: %#.4f", this.perturbStrength);
            s = String.valueOf(s) + String.format("\nPerturb Scale: %#.4f", this.perturbScale);
            s = String.valueOf(s) + String.format("\nP1: %#.4f", this.p1);
            s = String.valueOf(s) + String.format("\nP2: %#.4f", this.p2);
            s = String.valueOf(s) + String.format("\nFloor Height: %#.4f", this.floorHeight);
            s = String.valueOf(s) + String.format("\nEjecta Strength: %#.4f", this.ejectaStrength);
            s = String.valueOf(s) + String.format("\nEjecta Stretch: %#.4f", this.ejectaStretch);
            s = String.valueOf(s) + String.format("\nEjecta Perturb Strength: %#.4f", this.ejectaPerturbStrength);
            s = String.valueOf(s) + String.format("\nEjecta Perturb Scale: %#.4f", this.ejectaPerturbScale);
            s = String.valueOf(s) + String.format("\nFull peak size: %#.4f", this.fullPeakSize);
            s = String.valueOf(s) + String.format("\nRing Threshold: %#.4f", this.ringThreshold);
            s = String.valueOf(s) + String.format("\nRing funct mul: %#.4f", this.ringFunctMul);
            return s;
        }
    }
}

