/*
 * Decompiled with CFR 0.152.
 */
package theGhastModding.planetGen.utils;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import theGhastModding.planetGen.noise.NoiseConfig;
import theGhastModding.planetGen.utils.GlobalConfiguration;
import theGhastModding.planetGen.utils.NoiseUtils;
import theGhastModding.planetGen.utils.ProgressBars;

public class NoisemapGenerator {
    private static final int maxThreads = GlobalConfiguration.MAX_THREADS;
    private static final NoisemapRunner[] noisemapRunners = new NoisemapRunner[maxThreads];
    private static final ThreadPoolExecutor threadPool;
    private static volatile double[][] mapBuffer;

    static {
        int i = 0;
        while (i < maxThreads) {
            NoisemapGenerator.noisemapRunners[i] = new NoisemapRunner(i, maxThreads);
            ++i;
        }
        threadPool = (ThreadPoolExecutor)Executors.newCachedThreadPool();
        mapBuffer = null;
    }

    public static synchronized void genNoisemap(double[][] mapOutput, NoiseConfig noiseConfig, double[][] noiseMul, double planetSizeScale, boolean debugProgress) {
        if (mapBuffer == null || mapBuffer.length < mapOutput.length || mapBuffer[0].length < mapOutput[0].length) {
            mapBuffer = new double[mapOutput.length][mapOutput[0].length];
        }
        double oldLatScale = noiseConfig.noiseLatitudeScale;
        double oldLonScale = noiseConfig.noiseLongitudeScale;
        noiseConfig.noiseLatitudeScale *= planetSizeScale;
        noiseConfig.noiseLongitudeScale *= planetSizeScale;
        try {
            int i = 0;
            while (i < maxThreads) {
                noisemapRunners[i].prepare(mapBuffer, mapOutput.length, mapOutput[0].length, noiseConfig, noiseMul, debugProgress && i == 0);
                threadPool.submit(noisemapRunners[i]);
                ++i;
            }
            while (threadPool.getActiveCount() > 0) {
                try {
                    Thread.sleep(240L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            i = 0;
            while (i < mapOutput.length) {
                System.arraycopy(mapBuffer[i], 0, mapOutput[i], 0, mapOutput[i].length);
                ++i;
            }
        }
        finally {
            noiseConfig.noiseLatitudeScale = oldLatScale;
            noiseConfig.noiseLongitudeScale = oldLonScale;
        }
    }

    public static void cleanUp() {
        threadPool.shutdown();
    }

    private static class NoisemapRunner
    implements Runnable {
        private final int indx;
        private final int threadCount;
        private NoiseConfig noiseConfig;
        private double[][] mapOutput;
        private double[][] noiseMul;
        private boolean debugProgress;
        private int from;
        private int to;
        private int height;

        public NoisemapRunner(int indx, int threadCount) {
            this.indx = indx;
            this.threadCount = threadCount;
        }

        public void prepare(double[][] mapOutput, int width, int height, NoiseConfig noiseConfig, double[][] noiseMul, boolean debugProgress) {
            this.mapOutput = mapOutput;
            this.noiseConfig = noiseConfig;
            this.noiseMul = noiseMul;
            this.debugProgress = debugProgress;
            this.height = height;
            this.from = (int)((double)width / (double)this.threadCount * (double)this.indx);
            this.to = this.indx == this.threadCount - 1 ? width : (int)((double)width / (double)this.threadCount * (double)(this.indx + 1));
        }

        @Override
        public void run() {
            if (this.debugProgress) {
                ProgressBars.printBar();
            }
            int i = 0;
            while (i < this.to - this.from) {
                if (this.debugProgress) {
                    ProgressBars.printProgress(i, this.to - this.from);
                }
                int j = 0;
                while (j < this.height) {
                    if (this.noiseMul != null && this.noiseMul[i + this.from][j] <= 0.0) {
                        this.mapOutput[i + this.from][j] = 0.0;
                    } else {
                        this.mapOutput[i + this.from][j] = NoiseUtils.sampleSpherableNoise(i + this.from, j, this.mapOutput.length, this.mapOutput[0].length, this.noiseConfig);
                        if (this.noiseMul != null) {
                            double[] dArray = this.mapOutput[i + this.from];
                            int n = j;
                            dArray[n] = dArray[n] * this.noiseMul[i + this.from][j];
                        }
                    }
                    ++j;
                }
                ++i;
            }
            if (this.debugProgress) {
                ProgressBars.finishProgress();
            }
        }
    }
}

