/*
 * Decompiled with CFR 0.152.
 */
package tholin.planet9.gens;

import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import theGhastModding.planetGen.generators.GeneratorResult;
import tholin.planet9.gens.GenMain;
import tholin.planet9.gens.MajorMoonPanel;
import tholin.planet9.gens.MinorMoonsPanel;
import tholin.planet9.gens.PreviewDialog;
import tholin.planet9.gens.StartGeneratorPanel;
import tholin.planet9.gens.SystemGenerator;

public class GenPanel
extends JPanel {
    private static final long serialVersionUID = 4983719830087326537L;
    private SystemGenerator gen = null;
    private PreviewDialog previewDialog = new PreviewDialog();
    private int currentSelectedPane = -1;
    private PreviewGenThread genThread;
    private Thread genThreadThread;
    private JTabbedPane tabbedPane;
    private MajorMoonPanel p9Panel;
    private MajorMoonPanel[] majorMoonPanels;
    private MinorMoonsPanel minorMoonsPanel;

    public GenPanel() {
        this.gen = new SystemGenerator(6);
        this.gen.prepareInitialConfigs();
        this.genThread = new PreviewGenThread(this.gen);
        this.setPreferredSize(new Dimension(664, 664));
        this.setLayout(null);
        JLabel lblPlanet = new JLabel("Planet 9 - System generator tool");
        lblPlanet.setFont(new Font("Dialog", 1, 15));
        lblPlanet.setBounds(17, 13, 280, 28);
        this.add(lblPlanet);
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.setBounds(12, 53, 640, 599);
        this.add(this.tabbedPane);
        this.p9Panel = new MajorMoonPanel("Planet 9", this.gen.getP9Seed(), 1068000, this.gen.getP9Settings(), this, -1);
        JScrollPane scroller = new JScrollPane(this.p9Panel, 22, 30);
        scroller.setPreferredSize(new Dimension(620, 599));
        this.tabbedPane.addTab("Planet 9", scroller);
        this.majorMoonPanels = new MajorMoonPanel[5];
        MajorMoonPanel mmPanel3118 = new MajorMoonPanel("3118", this.gen.getConfigSeed(0), this.gen.getMajorMoonRadius(0), this.gen.getConfig(0), this, 0);
        scroller = new JScrollPane(mmPanel3118, 22, 30);
        scroller.setPreferredSize(new Dimension(620, 599));
        this.tabbedPane.addTab("3118", scroller);
        this.majorMoonPanels[0] = mmPanel3118;
        MajorMoonPanel mmPanel2352 = new MajorMoonPanel("2352", this.gen.getConfigSeed(1), this.gen.getMajorMoonRadius(1), this.gen.getConfig(1), this, 1);
        scroller = new JScrollPane(mmPanel2352, 22, 30);
        scroller.setPreferredSize(new Dimension(620, 599));
        this.tabbedPane.addTab("2352", scroller);
        this.majorMoonPanels[1] = mmPanel2352;
        MajorMoonPanel mmPanel4001 = new MajorMoonPanel("4001", this.gen.getConfigSeed(2), this.gen.getMajorMoonRadius(2), this.gen.getConfig(2), this, 2);
        scroller = new JScrollPane(mmPanel4001, 22, 30);
        scroller.setPreferredSize(new Dimension(620, 599));
        this.tabbedPane.addTab("4001", scroller);
        this.majorMoonPanels[2] = mmPanel4001;
        MajorMoonPanel mmPanel463 = new MajorMoonPanel("463", this.gen.getConfigSeed(3), this.gen.getMajorMoonRadius(3), this.gen.getConfig(3), this, 3);
        scroller = new JScrollPane(mmPanel463, 22, 30);
        scroller.setPreferredSize(new Dimension(620, 599));
        this.tabbedPane.addTab("463", scroller);
        this.majorMoonPanels[3] = mmPanel463;
        MajorMoonPanel mmPanel124 = new MajorMoonPanel("124", this.gen.getConfigSeed(4), this.gen.getMajorMoonRadius(4), this.gen.getConfig(4), this, 4);
        scroller = new JScrollPane(mmPanel124, 22, 30);
        scroller.setPreferredSize(new Dimension(620, 599));
        this.tabbedPane.addTab("124", scroller);
        this.majorMoonPanels[4] = mmPanel124;
        this.minorMoonsPanel = new MinorMoonsPanel(this.gen, this);
        this.tabbedPane.addTab("Minor moons", this.minorMoonsPanel);
        this.tabbedPane.addTab("Generator control", new StartGeneratorPanel(this.gen, this));
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (GenPanel.this.tabbedPane.getSelectedIndex() != GenPanel.this.currentSelectedPane) {
                    GenPanel.this.currentSelectedPane = GenPanel.this.tabbedPane.getSelectedIndex();
                    if (GenPanel.this.currentSelectedPane - 1 >= 5) {
                        return;
                    }
                    if (GenPanel.this.currentSelectedPane == 0 && !GenPanel.this.p9Panel.hasPreview() || GenPanel.this.currentSelectedPane > 0 && !GenPanel.this.majorMoonPanels[GenPanel.this.currentSelectedPane - 1].hasPreview()) {
                        GenPanel.this.triggerPreviewRegen(GenPanel.this.currentSelectedPane - 1, false);
                    }
                }
            }
        });
    }

    synchronized void setTabbedPaneEnabled(boolean b) {
        this.tabbedPane.setEnabled(b);
    }

    synchronized void triggerPreviewRegen(int idx, boolean minorMoons) {
        MajorMoonPanel panel;
        MajorMoonPanel majorMoonPanel = panel = idx == -1 ? this.p9Panel : this.majorMoonPanels[idx];
        if (this.genThreadThread != null && this.genThreadThread.isAlive()) {
            return;
        }
        if (minorMoons) {
            this.minorMoonsPanel.setApplyAndRenderEnabled(false);
        } else {
            if (idx == -1) {
                if (panel.getSeed() != this.gen.getP9Seed()) {
                    this.gen.changeP9Seed(panel.getSeed());
                    panel.updateAdvancedSettings(this.gen.getP9Settings());
                }
            } else if (panel.getSeed() != this.gen.getConfigSeed(idx)) {
                this.gen.changeConfigSeed(idx, panel.getSeed());
                panel.updateAdvancedSettings(this.gen.getConfig(idx));
            }
            panel.setApplyEnabled(false);
        }
        this.tabbedPane.setEnabled(false);
        this.previewDialog.setVisible(true);
        this.previewDialog.setLocationRelativeTo(GenMain.frame);
        this.genThread.setIdx(idx, minorMoons);
        this.genThreadThread = new Thread(this.genThread);
        this.genThreadThread.start();
    }

    private class PreviewGenThread
    implements Runnable {
        private int idx;
        private boolean minorMoons;
        private SystemGenerator gen;

        public PreviewGenThread(SystemGenerator gen) {
            this.gen = gen;
        }

        public void setIdx(int idx, boolean minorMoons) {
            this.idx = idx;
            this.minorMoons = minorMoons;
        }

        @Override
        public void run() {
            try {
                if (this.minorMoons) {
                    int i = 0;
                    while (i < this.gen.getMinorMoonCount()) {
                        GeneratorResult res = this.gen.genMinorMoonPreviewMaps(i);
                        GenPanel.this.minorMoonsPanel.updatePreviews(i, res);
                        ++i;
                    }
                } else if (this.idx == -1) {
                    GeneratorResult res = this.gen.genP9PreviewMaps();
                    GenPanel.this.p9Panel.updatePreviews(res);
                } else {
                    GeneratorResult res = this.gen.genMajorMoonPreviewMaps(this.idx);
                    GenPanel.this.majorMoonPanels[this.idx].updatePreviews(res);
                }
            }
            catch (Exception e) {
                GenPanel.this.previewDialog.setVisible(false);
                JOptionPane.showMessageDialog(GenMain.frame, "Error generating previews: " + e.getLocalizedMessage(), "Error", 0);
                e.printStackTrace();
                System.exit(1);
            }
            GenPanel.this.previewDialog.setVisible(false);
            GenPanel.this.tabbedPane.setEnabled(true);
            if (this.minorMoons) {
                GenPanel.this.minorMoonsPanel.setApplyAndRenderEnabled(true);
            } else if (this.idx == -1) {
                GenPanel.this.p9Panel.setApplyEnabled(true);
            } else {
                GenPanel.this.majorMoonPanels[this.idx].setApplyEnabled(true);
            }
        }
    }
}

