/*
 * Decompiled with CFR 0.152.
 */
package tholin.planet9.gens;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import theGhastModding.planetGen.generators.GeneratorResult;
import theGhastModding.planetGen.generators.GraymoonGen;
import theGhastModding.planetGen.utils.MapUtils;
import tholin.planet9.gens.GenMain;
import tholin.planet9.gens.GenPanel;
import tholin.planet9.gens.QaDPlanetRenderer;

public class MajorMoonPanel
extends JPanel {
    private static final long serialVersionUID = -7213743980514472403L;
    private GraymoonGen.GraymoonGenSettings settings;
    private boolean hasPreview = false;
    private QaDPlanetRenderer pRenderer;
    private BufferedImage img;
    private long seed;
    private JTextField textField;
    private JTextField textField_1;
    private JButton btnApply;
    private JPanel previewPanel;
    private JCheckBox chckbxHasMaria;
    private JLabel lblMariaCraterCount;
    private JSpinner spinner;
    private JSpinner spinner_1;
    private JSpinner spinner_2;
    private JSpinner spinner_3;
    private JSpinner spinner_4;
    private JSpinner spinner_5;
    private JSpinner spinner_6;
    private JSpinner spinner_7;
    private JSpinner spinner_8;
    private JSpinner spinner_9;
    private JPanel panel_1;
    private JPanel panel_2;
    private JPanel panel_3;
    private JPanel panel_4;

    public MajorMoonPanel(String name, long seed1, int radius, final GraymoonGen.GraymoonGenSettings settings, final GenPanel parent, final int idx) {
        this.seed = seed1;
        this.settings = settings;
        this.setPreferredSize(new Dimension(616, 1000));
        this.setLayout(null);
        this.pRenderer = new QaDPlanetRenderer((double)radius / 1000.0);
        this.img = new BufferedImage(221, 221, 1);
        this.previewPanel = new JPanel(){

            @Override
            public void paint(Graphics g) {
                g.drawImage(MajorMoonPanel.this.img, 0, 0, MajorMoonPanel.this.img.getWidth(), MajorMoonPanel.this.img.getHeight(), this);
            }
        };
        this.previewPanel.setBorder(new LineBorder(new Color(99, 130, 191), 1));
        this.previewPanel.setBounds(383, 34, 221, 221);
        this.add(this.previewPanel);
        JLabel lblPreview = new JLabel("Preview");
        lblPreview.setFont(new Font("Dialog", 1, 15));
        lblPreview.setBounds(383, 12, 96, 18);
        this.add(lblPreview);
        JLabel lblBodyname = new JLabel(name);
        lblBodyname.setFont(new Font("Dialog", 1, 15));
        lblBodyname.setBounds(12, 14, 106, 17);
        this.add(lblBodyname);
        JSeparator separator = new JSeparator();
        separator.setBounds(12, 267, 592, 2);
        this.add(separator);
        final JCheckBox chckbxAdvancedSettings = new JCheckBox("Advanced Settings");
        chckbxAdvancedSettings.setBounds(8, 243, 173, 23);
        this.add(chckbxAdvancedSettings);
        JLabel lblSeed = new JLabel("Name:");
        lblSeed.setBounds(12, 53, 70, 15);
        this.add(lblSeed);
        this.textField = new JTextField();
        this.textField.setText(name);
        this.textField.setBounds(100, 51, 271, 19);
        this.add(this.textField);
        this.textField.setColumns(10);
        JLabel lblSeed_1 = new JLabel("Seed:");
        lblSeed_1.setBounds(12, 81, 70, 15);
        this.add(lblSeed_1);
        this.textField_1 = new JTextField();
        this.textField_1.setText(Long.toString(this.seed));
        this.textField_1.setBounds(100, 79, 271, 19);
        this.add(this.textField_1);
        this.textField_1.setColumns(10);
        JLabel lblTextureResolution = new JLabel("Texture resolution:");
        lblTextureResolution.setBounds(12, 108, 151, 15);
        this.add(lblTextureResolution);
        final JLabel lblX = new JLabel("x " + Integer.toString(settings.width / 2));
        lblX.setBounds(236, 108, 70, 15);
        this.add(lblX);
        this.spinner = new JSpinner();
        this.spinner.setModel(new SpinnerNumberModel(8192, 5120, 655360, 2));
        this.spinner.setBounds(170, 106, 58, 20);
        this.spinner.setValue(settings.width);
        this.add(this.spinner);
        this.spinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                int num = (Integer)MajorMoonPanel.this.spinner.getValue();
                lblX.setText("x " + Integer.toString(num / 2));
            }
        });
        this.chckbxHasMaria = new JCheckBox("Has Maria");
        this.chckbxHasMaria.setSelected(settings.mariaLatitudeRange > 0.0);
        this.chckbxHasMaria.setEnabled(false);
        this.chckbxHasMaria.setBounds(12, 293, 129, 23);
        this.add(this.chckbxHasMaria);
        this.lblMariaCraterCount = new JLabel("Maria crater count:");
        this.lblMariaCraterCount.setEnabled(false);
        this.lblMariaCraterCount.setBounds(142, 297, 162, 15);
        this.add(this.lblMariaCraterCount);
        this.spinner_1 = new JSpinner();
        this.spinner_1.setEnabled(false);
        this.spinner_1.setModel(new SpinnerNumberModel(6, 0, 32, 1));
        this.spinner_1.setValue(settings.mariaCraterCount);
        this.spinner_1.setBounds(310, 295, 61, 20);
        this.add(this.spinner_1);
        final JLabel lblRegularCraterCount = new JLabel("Regular crater count:");
        lblRegularCraterCount.setEnabled(false);
        lblRegularCraterCount.setBounds(12, 324, 169, 15);
        this.add(lblRegularCraterCount);
        this.spinner_2 = new JSpinner();
        this.spinner_2.setModel(new SpinnerNumberModel(8192, 1, 65536, 1));
        this.spinner_2.setValue(settings.smallCraterCount);
        this.spinner_2.setEnabled(false);
        this.spinner_2.setBounds(310, 322, 61, 20);
        this.add(this.spinner_2);
        final JLabel lblHugeCraterCount = new JLabel("Huge crater count:");
        lblHugeCraterCount.setEnabled(false);
        lblHugeCraterCount.setBounds(12, 351, 220, 15);
        this.add(lblHugeCraterCount);
        this.spinner_3 = new JSpinner();
        this.spinner_3.setEnabled(false);
        this.spinner_3.setModel(new SpinnerNumberModel(3, 0, 32, 1));
        this.spinner_3.setValue(settings.hugeCraterCount);
        this.spinner_3.setBounds(310, 349, 61, 20);
        this.add(this.spinner_3);
        final JLabel lblCraterMaxSize = new JLabel("Crater size range:");
        lblCraterMaxSize.setEnabled(false);
        lblCraterMaxSize.setBounds(12, 378, 151, 15);
        this.add(lblCraterMaxSize);
        this.spinner_4 = new JSpinner();
        this.spinner_4.setEnabled(false);
        this.spinner_4.setModel(new SpinnerNumberModel(64, 5, 8192, 1));
        this.spinner_4.setValue(settings.craterMaxsize);
        this.spinner_4.setBounds(400, 376, 61, 20);
        this.add(this.spinner_4);
        this.spinner_5 = new JSpinner();
        this.spinner_5.setEnabled(false);
        this.spinner_5.setModel(new SpinnerNumberModel(2.0, 2.0, 4096.0, 1.0));
        this.spinner_5.setValue(settings.craterMinsize);
        this.spinner_5.setBounds(310, 376, 61, 20);
        this.add(this.spinner_5);
        final JLabel label = new JLabel("-");
        label.setEnabled(false);
        label.setBounds(383, 378, 12, 15);
        this.add(label);
        final JLabel lblMariaCraterSize = new JLabel("Maria crater size range:");
        lblMariaCraterSize.setEnabled(false);
        lblMariaCraterSize.setBounds(12, 405, 203, 15);
        this.add(lblMariaCraterSize);
        this.spinner_6 = new JSpinner(new SpinnerNumberModel(16.0, 5.0, 8192.0, 1.0));
        this.spinner_6.setValue(settings.mariaCraterMaxsize);
        this.spinner_6.setEnabled(false);
        this.spinner_6.setBounds(400, 403, 61, 20);
        this.add(this.spinner_6);
        final JLabel label_1 = new JLabel("-");
        label_1.setEnabled(false);
        label_1.setBounds(383, 405, 12, 15);
        this.add(label_1);
        this.spinner_7 = new JSpinner(new SpinnerNumberModel(2.0, 2.0, 4096.0, 1.0));
        this.spinner_7.setValue(settings.mariaCraterMinsize);
        this.spinner_7.setEnabled(false);
        this.spinner_7.setBounds(310, 403, 61, 20);
        this.add(this.spinner_7);
        final JLabel lblFlattenedCraterFade = new JLabel("Flattened crater fade range:");
        lblFlattenedCraterFade.setEnabled(false);
        lblFlattenedCraterFade.setBounds(12, 432, 260, 15);
        this.add(lblFlattenedCraterFade);
        this.spinner_8 = new JSpinner();
        this.spinner_8.setEnabled(false);
        this.spinner_8.setModel(new SpinnerNumberModel(14.0, 4.0, 256.0, 1.0));
        this.spinner_8.setValue(settings.craterFlattenedStart);
        this.spinner_8.setBounds(310, 430, 61, 20);
        this.add(this.spinner_8);
        final JLabel label_2 = new JLabel("-");
        label_2.setEnabled(false);
        label_2.setBounds(383, 432, 12, 15);
        this.add(label_2);
        this.spinner_9 = new JSpinner();
        this.spinner_9.setEnabled(false);
        this.spinner_9.setModel(new SpinnerNumberModel(28.0, 8.0, 256.0, 1.0));
        this.spinner_9.setValue(settings.craterFlattenedEnd);
        this.spinner_9.setBounds(400, 430, 61, 20);
        this.add(this.spinner_9);
        final JLabel lblNoisemapConfiguration = new JLabel("Noisemap configuration (click to configure)");
        lblNoisemapConfiguration.setEnabled(false);
        lblNoisemapConfiguration.setBounds(12, 464, 324, 15);
        this.add(lblNoisemapConfiguration);
        JSeparator separator_1 = new JSeparator();
        separator_1.setBounds(12, 485, 592, 2);
        this.add(separator_1);
        final JButton btnMariaNoise = new JButton("Maria Noise");
        btnMariaNoise.setEnabled(false);
        btnMariaNoise.setBounds(12, 491, 260, 25);
        this.add(btnMariaNoise);
        final JButton btnMountainBiomeNoise = new JButton("Mountain biome noise");
        btnMountainBiomeNoise.setEnabled(false);
        btnMountainBiomeNoise.setBounds(284, 491, 260, 25);
        this.add(btnMountainBiomeNoise);
        final JButton btnGroundNoiselarge = new JButton("Ground noise (large detail)");
        btnGroundNoiselarge.setEnabled(false);
        btnGroundNoiselarge.setBounds(12, 528, 260, 25);
        this.add(btnGroundNoiselarge);
        final JButton btnGroundNoisemedium = new JButton("Ground noise (medium detail)");
        btnGroundNoisemedium.setEnabled(false);
        btnGroundNoisemedium.setBounds(284, 528, 260, 25);
        this.add(btnGroundNoisemedium);
        final JButton btnGroundNoisesmall = new JButton("Ground noise (small detail)");
        btnGroundNoisesmall.setEnabled(false);
        btnGroundNoisesmall.setBounds(12, 565, 260, 25);
        this.add(btnGroundNoisesmall);
        final JButton btnMountainNoise = new JButton("Mountain noise");
        btnMountainNoise.setEnabled(false);
        btnMountainNoise.setBounds(284, 565, 260, 25);
        this.add(btnMountainNoise);
        final JButton btnCraterPeakNoise = new JButton("Crater peak noise");
        btnCraterPeakNoise.setEnabled(false);
        btnCraterPeakNoise.setBounds(12, 602, 260, 25);
        this.add(btnCraterPeakNoise);
        final JButton btnColorNoise = new JButton("Color noise");
        btnColorNoise.setEnabled(false);
        btnColorNoise.setBounds(284, 602, 260, 25);
        this.add(btnColorNoise);
        final JButton btnSecondaryColorNoise = new JButton("Secondary color noise");
        btnSecondaryColorNoise.setEnabled(false);
        btnSecondaryColorNoise.setBounds(12, 639, 260, 25);
        this.add(btnSecondaryColorNoise);
        final JLabel lblColorConfiguration = new JLabel("Color configuration");
        lblColorConfiguration.setEnabled(false);
        lblColorConfiguration.setBounds(12, 683, 294, 15);
        this.add(lblColorConfiguration);
        JSeparator separator_2 = new JSeparator();
        separator_2.setBounds(12, 703, 592, 2);
        this.add(separator_2);
        this.panel_1 = new JPanel();
        this.panel_1.setBackground(this.RGB(settings.normalColor));
        this.panel_1.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.panel_1.setBounds(142, 710, 32, 32);
        this.add(this.panel_1);
        final JLabel lblBaseColor = new JLabel("Base color:");
        lblBaseColor.setEnabled(false);
        lblBaseColor.setBounds(12, 719, 118, 15);
        this.add(lblBaseColor);
        this.panel_2 = new JPanel();
        this.panel_2.setBackground(this.RGB(settings.mountainsColor));
        this.panel_2.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.panel_2.setBounds(142, 754, 32, 32);
        this.add(this.panel_2);
        this.panel_3 = new JPanel();
        this.panel_3.setBackground(this.RGB(settings.mariasColor));
        this.panel_3.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.panel_3.setBounds(142, 798, 32, 32);
        this.add(this.panel_3);
        this.panel_4 = new JPanel();
        this.panel_4.setBackground(this.RGB(settings.secondaryColor));
        this.panel_4.setBorder(new LineBorder(new Color(0, 0, 0)));
        this.panel_4.setBounds(142, 842, 32, 32);
        this.add(this.panel_4);
        final JLabel lblMountainsColor = new JLabel("Mountains:");
        lblMountainsColor.setEnabled(false);
        lblMountainsColor.setBounds(12, 765, 118, 15);
        this.add(lblMountainsColor);
        final JLabel lblMaria = new JLabel("Maria:");
        lblMaria.setEnabled(false);
        lblMaria.setBounds(12, 809, 70, 15);
        this.add(lblMaria);
        final JLabel lblSecondary = new JLabel("Secondary:");
        lblSecondary.setEnabled(false);
        lblSecondary.setBounds(12, 852, 106, 15);
        this.add(lblSecondary);
        final JButton btnChange = new JButton("Change");
        btnChange.setEnabled(false);
        btnChange.setBounds(186, 717, 106, 25);
        this.add(btnChange);
        btnChange.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Color c = JColorChooser.showDialog(GenMain.frame, "Choose color", MajorMoonPanel.this.panel_1.getBackground());
                if (c != null) {
                    MajorMoonPanel.this.panel_1.setBackground(c);
                }
            }
        });
        final JButton button = new JButton("Change");
        button.setEnabled(false);
        button.setBounds(186, 761, 106, 25);
        this.add(button);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Color c = JColorChooser.showDialog(GenMain.frame, "Choose color", MajorMoonPanel.this.panel_2.getBackground());
                if (c != null) {
                    MajorMoonPanel.this.panel_2.setBackground(c);
                }
            }
        });
        final JButton button_1 = new JButton("Change");
        button_1.setEnabled(false);
        button_1.setBounds(186, 804, 106, 25);
        this.add(button_1);
        button_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Color c = JColorChooser.showDialog(GenMain.frame, "Choose color", MajorMoonPanel.this.panel_3.getBackground());
                if (c != null) {
                    MajorMoonPanel.this.panel_3.setBackground(c);
                }
            }
        });
        final JButton button_2 = new JButton("Change");
        button_2.setEnabled(false);
        button_2.setBounds(186, 849, 106, 25);
        this.add(button_2);
        button_2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Color c = JColorChooser.showDialog(GenMain.frame, "Choose color", MajorMoonPanel.this.panel_4.getBackground());
                if (c != null) {
                    MajorMoonPanel.this.panel_4.setBackground(c);
                }
            }
        });
        this.btnApply = new JButton("Apply");
        this.btnApply.setBounds(12, 156, 117, 25);
        this.add(this.btnApply);
        this.btnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int width;
                settings.width = width = ((Integer)MajorMoonPanel.this.spinner.getValue()).intValue();
                settings.height = width / 2;
                long newSeed = 0L;
                try {
                    newSeed = Long.parseLong(MajorMoonPanel.this.textField_1.getText());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    newSeed = MajorMoonPanel.this.textField_1.getText().hashCode();
                }
                if (newSeed != MajorMoonPanel.this.seed && chckbxAdvancedSettings.isSelected()) {
                    int res = JOptionPane.showConfirmDialog(GenMain.frame, "Warning: you have changed the configuration seed. Proceeding with a new seed will re-generate the configuration settings randomly, wiping any changes you may have made in the advanced settings. Are you sure you want to continue?\n(Pressing \u2019No\u2019 will change the seed back and keep you changes to the advanced settings)", "Warning", 0, 2);
                    if (res != 0) {
                        MajorMoonPanel.this.textField_1.setText(Long.toString(MajorMoonPanel.this.seed));
                        return;
                    }
                    MajorMoonPanel.this.seed = newSeed;
                    parent.triggerPreviewRegen(idx, false);
                    return;
                }
                settings.normalColor = MapUtils.RGB(MajorMoonPanel.this.panel_1.getBackground());
                settings.mountainsColor = MapUtils.RGB(MajorMoonPanel.this.panel_2.getBackground());
                settings.mariasColor = MapUtils.RGB(MajorMoonPanel.this.panel_3.getBackground());
                settings.secondaryColor = MapUtils.RGB(MajorMoonPanel.this.panel_4.getBackground());
                if (MajorMoonPanel.this.chckbxHasMaria.isSelected()) {
                    settings.mariaLongitudeRange = 181.0;
                    settings.mariaLatitudeRange = 91.0;
                    settings.mariaCraterCount = (Integer)MajorMoonPanel.this.spinner_1.getValue();
                } else {
                    settings.mariaLongitudeRange = -181.0;
                    settings.mariaLatitudeRange = -91.0;
                    settings.mariaCraterCount = 0;
                }
                settings.smallCraterCount = (Integer)MajorMoonPanel.this.spinner_2.getValue();
                settings.hugeCraterCount = (Integer)MajorMoonPanel.this.spinner_3.getValue();
                settings.craterMinsize = (Double)MajorMoonPanel.this.spinner_5.getValue();
                settings.craterMaxsize = (Double)MajorMoonPanel.this.spinner_4.getValue();
                settings.mariaCraterMinsize = (Double)MajorMoonPanel.this.spinner_7.getValue();
                settings.mariaCraterMaxsize = (Double)MajorMoonPanel.this.spinner_6.getValue();
                settings.craterFlattenedStart = (Integer)MajorMoonPanel.this.spinner_8.getValue();
                settings.craterFlattenedEnd = (Integer)MajorMoonPanel.this.spinner_9.getValue();
                parent.triggerPreviewRegen(idx, false);
            }
        });
        chckbxAdvancedSettings.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                boolean b = chckbxAdvancedSettings.isSelected();
                button.setEnabled(b);
                button_1.setEnabled(b);
                button_2.setEnabled(b);
                lblSecondary.setEnabled(b);
                lblMaria.setEnabled(b);
                lblMountainsColor.setEnabled(b);
                btnChange.setEnabled(b);
                lblBaseColor.setEnabled(b);
                MajorMoonPanel.this.panel_1.setEnabled(b);
                MajorMoonPanel.this.panel_2.setEnabled(b);
                MajorMoonPanel.this.panel_3.setEnabled(b);
                MajorMoonPanel.this.panel_4.setEnabled(b);
                btnMariaNoise.setEnabled(b);
                btnMountainBiomeNoise.setEnabled(b);
                btnGroundNoiselarge.setEnabled(b);
                btnGroundNoisemedium.setEnabled(b);
                btnGroundNoisesmall.setEnabled(b);
                btnMountainNoise.setEnabled(b);
                btnCraterPeakNoise.setEnabled(b);
                btnColorNoise.setEnabled(b);
                btnSecondaryColorNoise.setEnabled(b);
                lblColorConfiguration.setEnabled(b);
                lblNoisemapConfiguration.setEnabled(b);
                MajorMoonPanel.this.spinner_9.setEnabled(b);
                label_2.setEnabled(b);
                MajorMoonPanel.this.spinner_8.setEnabled(b);
                lblFlattenedCraterFade.setEnabled(b);
                MajorMoonPanel.this.spinner_7.setEnabled(b);
                label_1.setEnabled(b);
                MajorMoonPanel.this.spinner_6.setEnabled(b);
                lblMariaCraterSize.setEnabled(b);
                label.setEnabled(b);
                MajorMoonPanel.this.spinner_5.setEnabled(b);
                MajorMoonPanel.this.spinner_4.setEnabled(b);
                lblCraterMaxSize.setEnabled(b);
                MajorMoonPanel.this.spinner_3.setEnabled(b);
                lblHugeCraterCount.setEnabled(b);
                MajorMoonPanel.this.spinner_2.setEnabled(b);
                lblRegularCraterCount.setEnabled(b);
                MajorMoonPanel.this.spinner_1.setEnabled(b);
                MajorMoonPanel.this.lblMariaCraterCount.setEnabled(b);
                MajorMoonPanel.this.chckbxHasMaria.setEnabled(b);
            }
        });
    }

    private Color RGB(double[] d) {
        return new Color((int)(d[0] * 255.0), (int)(d[1] * 255.0), (int)(d[2] * 255.0));
    }

    public boolean hasPreview() {
        return this.hasPreview;
    }

    public void updatePreviews(GeneratorResult res) throws Exception {
        this.hasPreview = true;
        this.pRenderer.loadData(res, 10.0);
        this.pRenderer.render(this.img);
        Graphics2D g = (Graphics2D)this.previewPanel.getGraphics();
        g.drawImage(this.img, 0, 0, this.img.getWidth(), this.img.getHeight(), this);
    }

    public void updateAdvancedSettings(GraymoonGen.GraymoonGenSettings settings) {
        this.spinner.setValue(settings.width);
        this.chckbxHasMaria.setSelected(settings.mariaLatitudeRange > 0.0);
        this.lblMariaCraterCount.setEnabled(false);
        this.spinner_1.setValue(settings.mariaCraterCount);
        this.spinner_2.setValue(settings.smallCraterCount);
        this.spinner_3.setValue(settings.hugeCraterCount);
        this.spinner_5.setValue(settings.craterMinsize);
        this.spinner_4.setValue(settings.craterMaxsize);
        this.spinner_7.setValue(settings.mariaCraterMinsize);
        this.spinner_6.setValue(settings.mariaCraterMaxsize);
        this.spinner_8.setValue(settings.craterFlattenedStart);
        this.spinner_9.setValue(settings.craterFlattenedEnd);
        this.panel_1.setBackground(this.RGB(settings.normalColor));
        this.panel_2.setBackground(this.RGB(settings.mountainsColor));
        this.panel_3.setBackground(this.RGB(settings.mariasColor));
        this.panel_4.setBackground(this.RGB(settings.secondaryColor));
    }

    public void setApplyEnabled(boolean b) {
        this.btnApply.setEnabled(b);
    }

    public long getSeed() {
        return this.seed;
    }

    public String getChangedName() {
        return this.textField.getText();
    }

    public GraymoonGen.GraymoonGenSettings getChangedConfig() {
        return this.settings;
    }
}

