/*
 * Decompiled with CFR 0.152.
 */
package tholin.planet9.gens;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import theGhastModding.planetGen.generators.GeneratorResult;
import tholin.planet9.gens.GenPanel;
import tholin.planet9.gens.QaDPlanetRenderer;
import tholin.planet9.gens.SystemGenerator;

public class MinorMoonsPanel
extends JPanel {
    private static final long serialVersionUID = -2407957298219840897L;
    private JTextField textField;
    private JTextField textField_1;
    private JPanel[] previewPanels;
    private BufferedImage[] previewImgs;
    private QaDPlanetRenderer[] renderers;
    private JButton btnApply;
    private JButton btnGeneratePreviews;
    private long orbitsSeed;
    private long shapeSeed;

    public MinorMoonsPanel(final SystemGenerator gen, final GenPanel parent) {
        this.orbitsSeed = gen.getMinorMoonOrbitsSeed();
        this.shapeSeed = gen.getMinorMoonShapeSeed();
        this.setPreferredSize(new Dimension(616, 450));
        this.setLayout(null);
        JLabel lblMinorMoons = new JLabel("Minor moons");
        lblMinorMoons.setFont(new Font("Dialog", 1, 15));
        lblMinorMoons.setBounds(12, 12, 121, 15);
        this.add(lblMinorMoons);
        JLabel lblMinorMoonsCurrently = new JLabel("Minor moons currently cannot be configured individually.");
        lblMinorMoonsCurrently.setBounds(12, 49, 592, 15);
        this.add(lblMinorMoonsCurrently);
        JLabel lblOnlySomeBasic = new JLabel("Only some basic options are available for now.");
        lblOnlySomeBasic.setBounds(12, 66, 389, 15);
        this.add(lblOnlySomeBasic);
        JLabel lblMinorMoonOrbits = new JLabel("Minor moon orbits seed:");
        lblMinorMoonOrbits.setBounds(12, 103, 195, 15);
        this.add(lblMinorMoonOrbits);
        this.textField = new JTextField();
        this.textField.setText(Long.toString(gen.getMinorMoonOrbitsSeed()));
        this.textField.setColumns(10);
        this.textField.setBounds(225, 101, 271, 19);
        this.add(this.textField);
        JLabel lblMinorMoonShapes = new JLabel("Minor moon shapes seed:");
        lblMinorMoonShapes.setBounds(12, 130, 195, 15);
        this.add(lblMinorMoonShapes);
        this.textField_1 = new JTextField();
        this.textField_1.setText(Long.toString(gen.getMinorMoonShapeSeed()));
        this.textField_1.setColumns(10);
        this.textField_1.setBounds(225, 128, 271, 19);
        this.add(this.textField_1);
        this.btnApply = new JButton("Apply");
        this.btnApply.setBounds(12, 157, 117, 25);
        this.add(this.btnApply);
        JLabel lblPreviews = new JLabel("Previews");
        lblPreviews.setBounds(12, 210, 70, 15);
        this.add(lblPreviews);
        this.btnGeneratePreviews = new JButton("Generate previews");
        this.btnGeneratePreviews.setBounds(100, 205, 169, 25);
        this.add(this.btnGeneratePreviews);
        this.btnGeneratePreviews.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                parent.triggerPreviewRegen(0, true);
            }
        });
        JLabel lblDangerThisCould = new JLabel("Warning: this could take some time!");
        lblDangerThisCould.setForeground(Color.RED);
        lblDangerThisCould.setBounds(283, 210, 271, 15);
        this.add(lblDangerThisCould);
        int moonCount = gen.getMinorMoonCount();
        this.renderers = new QaDPlanetRenderer[moonCount];
        int i = 0;
        while (i < moonCount) {
            this.renderers[i] = new QaDPlanetRenderer(gen.getMinorMoonKopConfig((int)i).radius / 1000.0);
            ++i;
        }
        this.previewImgs = new BufferedImage[moonCount];
        this.previewPanels = new JPanel[moonCount];
        JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension(48 + moonCount * 174, 180));
        panel.setLayout(null);
        JScrollPane scroller = new JScrollPane(panel, 20, 32);
        scroller.setBounds(12, 237, 592, 200);
        scroller.setBorder(new LineBorder(UIManager.getColor("CheckBoxMenuItem.acceleratorForeground")));
        this.add(scroller);
        int i2 = 0;
        while (i2 < moonCount) {
            BufferedImage img;
            this.previewImgs[i2] = img = new BufferedImage(150, 150, 1);
            JPanel previewPanel = new JPanel(){

                @Override
                public void paint(Graphics g) {
                    g.drawImage(img, 0, 0, 150, 150, this);
                }
            };
            previewPanel.setBorder(new LineBorder(new Color(0, 0, 0)));
            previewPanel.setBounds(24 + i2 * 174, 15, 150, 150);
            panel.add(previewPanel);
            this.previewPanels[i2] = previewPanel;
            ++i2;
        }
        this.btnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                long newSeed = 0L;
                try {
                    newSeed = Long.parseLong(MinorMoonsPanel.this.textField.getText());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    newSeed = MinorMoonsPanel.this.textField.getText().hashCode();
                }
                if (newSeed != MinorMoonsPanel.this.orbitsSeed) {
                    MinorMoonsPanel.this.orbitsSeed = newSeed;
                    gen.changeMinorMoonOrbitsSeed(MinorMoonsPanel.this.orbitsSeed);
                }
                newSeed = 0L;
                try {
                    newSeed = Long.parseLong(MinorMoonsPanel.this.textField_1.getText());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    newSeed = MinorMoonsPanel.this.textField_1.getText().hashCode();
                }
                if (newSeed != MinorMoonsPanel.this.shapeSeed) {
                    MinorMoonsPanel.this.shapeSeed = newSeed;
                    gen.changeMinorMoonShapeSeed(MinorMoonsPanel.this.shapeSeed);
                }
            }
        });
    }

    public void setApplyAndRenderEnabled(boolean b) {
        this.btnApply.setEnabled(b);
        this.btnGeneratePreviews.setEnabled(b);
    }

    public void updatePreviews(int idx, GeneratorResult res) {
        this.renderers[idx].loadData(res, 10.0);
        this.renderers[idx].render(this.previewImgs[idx]);
        this.previewPanels[idx].repaint();
    }
}

