/*
 * Decompiled with CFR 0.152.
 */
package tholin.planet9.gens;

import java.awt.Color;
import java.awt.image.BufferedImage;
import theGhastModding.planetGen.generators.GeneratorResult;

public class QaDPlanetRenderer {
    private double radius;
    private double ambientLight = 0.15;
    private double stepResolution = 12.0;
    private double rotation = 0.0;
    private double[][] heightmap = null;
    private float[][][] parsedTexture = null;
    private double deformity;
    private Color lightColor = new Color(255, 250, 250);
    private double normalCalcOffset;
    private double sunX = 400000.0;
    private double sunZ = -400000.0;
    private static final double FOV = 0.65;

    public QaDPlanetRenderer(double radius) {
        this.radius = radius;
    }

    private double heightAt(int x, int y) {
        y %= this.heightmap[0].length;
        if ((x %= this.heightmap.length) < 0) {
            x = this.heightmap.length - 1 + x;
        }
        if (y < 0) {
            y = this.heightmap[0].length - 1 + y;
        }
        return this.heightmap[x][y];
    }

    public double sampleHeightmap(double x, double y) {
        x += this.rotation / 360.0 * (double)this.heightmap.length;
        x *= (double)this.heightmap.length;
        y *= (double)this.heightmap[0].length;
        x %= (double)this.heightmap.length;
        y %= (double)this.heightmap[0].length;
        if (x < 0.0) {
            x = (double)(this.heightmap.length - 1) + x;
        }
        if (y < 0.0) {
            y = (double)(this.heightmap[0].length - 1) + y;
        }
        int imgx = (int)x;
        int imgy = (int)y;
        double div1 = x - (double)imgx;
        double div2 = y - (double)imgy;
        double R1 = this.heightAt(imgx, imgy) * div1 + this.heightAt(imgx - 1, imgy) * (1.0 - div1);
        double R2 = this.heightAt(imgx, imgy - 1) * div1 + this.heightAt(imgx - 1, imgy - 1) * (1.0 - div1);
        double P = R1 * div2 + R2 * (1.0 - div2);
        return P * this.deformity;
    }

    private double[] heightmapNormal(double x, double y) {
        this.normalCalcOffset = 1.0 / ((double)this.heightmap.length * 2.0);
        double hs = this.deformity;
        double h1 = this.sampleHeightmap(x + this.normalCalcOffset, y) / hs;
        double h2 = this.sampleHeightmap(x, y + this.normalCalcOffset / 2.0) / hs;
        double h3 = this.sampleHeightmap(x - this.normalCalcOffset, y) / hs;
        double h4 = this.sampleHeightmap(x, y - this.normalCalcOffset / 2.0) / hs;
        double wx = -(h1 - h3);
        double wy = 1.0 / hs;
        double wz = h2 - h4;
        double len = Math.sqrt(wx * wx + wy * wy + wz * wz);
        wx /= len;
        double cosX = Math.cos((y * 180.0 - 0.0) * (Math.PI / 180));
        double sinX = Math.sin((y * 180.0 - 0.0) * (Math.PI / 180));
        double cosY = Math.cos((x * 360.0 - 180.0) * (Math.PI / 180));
        double sinY = Math.sin((x * 360.0 - 180.0) * (Math.PI / 180));
        double wyn = (wy /= len) * cosX - (wz /= len) * sinX;
        wz = wy * sinX + wz * cosX;
        wy = wyn;
        double wxn = wx * cosY + wz * sinY;
        wz = -wx * sinY + wz * cosY;
        wx = wxn;
        return new double[]{wx, wy, wz};
    }

    private double traceLight(double originX, double originY, double originZ, double lat, double lon) {
        double posX = originX;
        double posY = originY;
        double posZ = originZ;
        double toSunX = this.sunX - posX;
        double toSunY = -posY;
        double toSunZ = this.sunZ - posZ;
        double length = Math.sqrt(toSunX * toSunX + toSunY * toSunY + toSunZ * toSunZ);
        toSunX /= length;
        toSunY /= length;
        toSunZ /= length;
        double[] normal = this.heightmapNormal((lon + 90.0) / 360.0, lat / 180.0);
        length = toSunX * normal[0] + toSunY * normal[1] + toSunZ * normal[2];
        if (length < this.ambientLight) {
            length = this.ambientLight;
        }
        return length;
    }

    public void loadData(GeneratorResult res, double deformity) {
        this.heightmap = res.heightmapRaw;
        this.deformity = deformity;
        this.parsedTexture = new float[res.colorMap.getWidth()][res.colorMap.getHeight()][3];
        int i = 0;
        while (i < res.colorMap.getWidth()) {
            int j = 0;
            while (j < res.colorMap.getHeight()) {
                this.parsedTexture[i][j][0] = (float)(res.colorMap.getRGB(i, j) >> 16 & 0xFF) / 255.0f;
                this.parsedTexture[i][j][1] = (float)(res.colorMap.getRGB(i, j) >> 8 & 0xFF) / 255.0f;
                this.parsedTexture[i][j][2] = (float)(res.colorMap.getRGB(i, j) >> 0 & 0xFF) / 255.0f;
                ++j;
            }
            ++i;
        }
    }

    private double altitudeOver(double x, double y, double z) {
        double dist = Math.sqrt(x * x + y * y + z * z);
        double latitude = Math.acos(y /= dist) * 57.29577951308232;
        double longitude = (270.0 + Math.atan2(x /= dist, z /= dist) * 180.0 / Math.PI) % 360.0 - 180.0;
        return this.sampleHeightmap((longitude + 90.0) / 360.0, latitude / 180.0);
    }

    public void render(BufferedImage img) {
        int i = 0;
        while (i < img.getWidth()) {
            int j = 0;
            while (j < img.getHeight()) {
                double length;
                double[] a;
                double toImageX = 2.0 * (double)i / (double)img.getWidth() - 1.0;
                toImageX *= 0.65;
                double toImageY = -(2.0 * (double)j / (double)img.getWidth() - 1.0);
                toImageY *= 0.65;
                double toImageZ = 1.0;
                double sphereRadius = this.radius + this.deformity + 0.5;
                double cPos = -sphereRadius * 2.0;
                if ((a = QaDPlanetRenderer.raySphereIntersection(0.0, 0.0, 0.0, 0.0, 0.0, cPos, toImageX /= (length = Math.sqrt(toImageX * toImageX + toImageY * toImageY + toImageZ * toImageZ)), toImageY /= length, toImageZ /= length, sphereRadius)) == null) {
                    img.setRGB(i, j, 0);
                } else {
                    double t0 = Math.max(a[0], 0.0);
                    double t1 = Math.max(a[1], 0.0);
                    double dist0 = Math.sqrt(t0 * toImageX * t0 * toImageX + t0 * toImageY * t0 * toImageY + t0 * toImageZ * t0 * toImageZ);
                    double dist1 = Math.sqrt(t1 * toImageX * t1 * toImageX + t1 * toImageY * t1 * toImageY + t1 * toImageZ * t1 * toImageZ);
                    double isectClose = t0;
                    double isectFar = t1;
                    if (dist1 < dist0) {
                        isectClose = t1;
                        isectFar = t0;
                    }
                    double posX = isectClose * toImageX + 0.0;
                    double posY = isectClose * toImageY + 0.0;
                    double posZ = isectClose * toImageZ + cPos;
                    double vectx = isectFar * toImageX - isectClose * toImageX;
                    double vecty = isectFar * toImageY - isectClose * toImageY;
                    double vectz = isectFar * toImageZ - isectClose * toImageZ;
                    length = Math.sqrt(vectx * vectx + vecty * vecty + vectz * vectz);
                    vectx /= length;
                    vecty /= length;
                    vectz /= length;
                    vectx /= this.stepResolution;
                    vecty /= this.stepResolution;
                    vectz /= this.stepResolution;
                    double endx = 0.0 - (isectFar * toImageX + 0.0);
                    double endy = 0.0 - (isectFar * toImageY + 0.0);
                    double endz = 0.0 - (isectFar * toImageZ + cPos);
                    double enddist = Math.sqrt(endx * endx + endy * endy + endz * endz) * 1.05;
                    while (true) {
                        double distz;
                        double disty;
                        double distx;
                        double dist;
                        if ((dist = Math.sqrt((distx = 0.0 - posX) * distx + (disty = 0.0 - posY) * disty + (distz = 0.0 - posZ) * distz)) >= enddist) {
                            img.setRGB(i, j, 0);
                            break;
                        }
                        double val = this.altitudeOver(posX, posY, posZ);
                        if (dist <= this.radius + val) {
                            double[] latlong = QaDPlanetRenderer.latlong(posX, posY, posZ);
                            double latitude = latlong[0];
                            double longitude = latlong[1];
                            float[] col = this.sampleTexture((longitude + 90.0) / 360.0, latitude / 180.0);
                            double l = this.traceLight(posX, posY, posZ, latitude, longitude);
                            l = Math.max(Math.min(l, 1.0), 0.0);
                            col[0] = (float)((double)col[0] * (l * ((double)this.lightColor.getRed() / 255.0)));
                            col[1] = (float)((double)col[1] * (l * ((double)this.lightColor.getGreen() / 255.0)));
                            col[2] = (float)((double)col[2] * (l * ((double)this.lightColor.getBlue() / 255.0)));
                            int r = (int)((double)col[0] * 255.0);
                            int g = (int)((double)col[1] * 255.0);
                            int b = (int)((double)col[2] * 255.0);
                            if (r > 255) {
                                r = 255;
                            }
                            if (g > 255) {
                                g = 255;
                            }
                            if (b > 255) {
                                b = 255;
                            }
                            if (r < 0) {
                                r = 0;
                            }
                            if (g < 0) {
                                g = 0;
                            }
                            if (b < 0) {
                                b = 0;
                            }
                            img.setRGB(i, j, b | g << 8 | r << 16);
                            break;
                        }
                        posX += vectx;
                        posY += vecty;
                        posZ += vectz;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private float[] textureAt(double x, double y) {
        int imgx = (int)x;
        int imgy = (int)y;
        imgy %= this.parsedTexture[0].length;
        if ((imgx %= this.parsedTexture.length) < 0) {
            imgx = this.parsedTexture.length - 1 + imgx;
        }
        if (imgy < 0) {
            imgy = this.parsedTexture[0].length - 1 + imgy;
        }
        return this.parsedTexture[imgx][imgy];
    }

    private float[] sampleTexture(double x, double y) {
        x += this.rotation / 360.0 * (double)this.heightmap.length;
        x *= (double)this.parsedTexture.length;
        y *= (double)this.parsedTexture[0].length;
        x %= (double)this.parsedTexture.length;
        y %= (double)this.parsedTexture[0].length;
        if (x < 0.0) {
            x = (double)(this.parsedTexture.length - 1) + x;
        }
        if (y < 0.0) {
            y = (double)(this.parsedTexture[0].length - 1) + y;
        }
        float div1 = (float)x - (float)((int)x);
        float div2 = (float)y - (float)((int)y);
        float[] colorsAt11 = this.textureAt(x, y);
        float[] colorsAt21 = this.textureAt(x - 1.0, y);
        float[] colorsAt12 = this.textureAt(x, y - 1.0);
        float[] colorsAt22 = this.textureAt(x - 1.0, y - 1.0);
        float R1r = colorsAt11[0] * div1 + colorsAt21[0] * (1.0f - div1);
        float R1g = colorsAt11[1] * div1 + colorsAt21[1] * (1.0f - div1);
        float R1b = colorsAt11[2] * div1 + colorsAt21[2] * (1.0f - div1);
        float R2r = colorsAt12[0] * div1 + colorsAt22[0] * (1.0f - div1);
        float R2g = colorsAt12[1] * div1 + colorsAt22[1] * (1.0f - div1);
        float R2b = colorsAt12[2] * div1 + colorsAt22[2] * (1.0f - div1);
        float P1 = R1r * div2 + R2r * (1.0f - div2);
        float P2 = R1g * div2 + R2g * (1.0f - div2);
        float P3 = R1b * div2 + R2b * (1.0f - div2);
        return new float[]{P1, P2, P3};
    }

    public static double[] raySphereIntersection(double posX, double posY, double posZ, double origX, double origY, double origZ, double dirX, double dirY, double dirZ, double radius) {
        double Lx = posX - origX;
        double Ly = posY - origY;
        double Lz = posZ - origZ;
        double tca = dirX * Lx;
        tca += dirY * Ly;
        tca += dirZ * Lz;
        double L_2 = Lx * Lx + Ly * Ly + Lz * Lz;
        if (tca <= 0.0 && Math.sqrt(L_2) > radius) {
            return null;
        }
        double d = L_2 - tca * tca;
        if (Math.sqrt(d) >= radius) {
            return null;
        }
        double thc = radius * radius - d;
        thc = Math.sqrt(thc);
        double t0 = tca - thc;
        double t1 = tca + thc;
        return new double[]{t0, t1};
    }

    public static double[] latlong(double x, double y, double z) {
        double dist = Math.sqrt(x * x + y * y + z * z);
        double latitude = Math.acos(y /= dist) * 57.29577951308232;
        double longitude = (270.0 + Math.atan2(x /= dist, z /= dist) * 180.0 / Math.PI) % 360.0 - 180.0;
        return new double[]{latitude, longitude};
    }
}

