/*
 * Decompiled with CFR 0.152.
 */
package tholin.planet9.gens;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import tholin.planet9.gens.GenMain;
import tholin.planet9.gens.GenPanel;
import tholin.planet9.gens.SystemGenerator;

public class StartGeneratorPanel
extends JPanel {
    private static final long serialVersionUID = 5821652537152647096L;
    private JTextField textField;
    private JButton btnNewButton;
    private JLabel lblStatus;
    private JProgressBar progressBar;
    private GenThread genThread;
    private Thread genThreadThread = null;
    private SystemGenerator gen;
    private GenPanel parent;

    public StartGeneratorPanel(SystemGenerator gen, final GenPanel parent) {
        this.gen = gen;
        this.parent = parent;
        this.genThread = new GenThread();
        this.setPreferredSize(new Dimension(616, 308));
        this.setLayout(null);
        JLabel lblStartGenerator = new JLabel("Generator control");
        lblStartGenerator.setFont(new Font("Dialog", 1, 15));
        lblStartGenerator.setBounds(12, 12, 156, 15);
        this.add(lblStartGenerator);
        JLabel lblGamedataFolderLocation = new JLabel("PluginData folder location:");
        lblGamedataFolderLocation.setBounds(12, 49, 210, 15);
        this.add(lblGamedataFolderLocation);
        this.textField = new JTextField();
        this.textField.setText(SystemGenerator.plugindataPath);
        this.textField.setBounds(240, 47, 210, 19);
        this.add(this.textField);
        this.textField.setColumns(10);
        final JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        fc.setAcceptAllFileFilterUsed(false);
        JButton btnBrowse = new JButton("Browse");
        btnBrowse.setBounds(462, 44, 117, 25);
        this.add(btnBrowse);
        this.btnNewButton = new JButton("START THE GENERATOR");
        this.btnNewButton.setFont(new Font("Dialog", 1, 18));
        this.btnNewButton.setBounds(12, 96, 592, 62);
        this.add(this.btnNewButton);
        this.lblStatus = new JLabel("Status: Idle");
        this.lblStatus.setBounds(12, 200, 592, 15);
        this.add(this.lblStatus);
        this.progressBar = new JProgressBar();
        this.progressBar.setBounds(12, 170, 592, 18);
        this.add(this.progressBar);
        JSeparator separator = new JSeparator();
        separator.setBounds(12, 227, 592, 2);
        this.add(separator);
        btnBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int o = fc.showOpenDialog(GenMain.frame);
                if (o == 0) {
                    File folder = fc.getSelectedFile();
                    if (!folder.exists()) {
                        JOptionPane.showMessageDialog(GenMain.frame, "The selected file does not exist", "Error", 0);
                        return;
                    }
                    if (!folder.isDirectory()) {
                        JOptionPane.showMessageDialog(GenMain.frame, "The selected file is not a directory", "Error", 0);
                        return;
                    }
                    StartGeneratorPanel.this.textField.setText(folder.getPath());
                }
            }
        });
        this.btnNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int res = JOptionPane.showConfirmDialog(GenMain.frame, "Warning! Running the generator will overwrite existing system. If you want to use the already existing system again in the future, back it up now!\nProceed?", "Overwrite warning", 0, 2);
                if (res != 0) {
                    return;
                }
                SystemGenerator.plugindataPath = StartGeneratorPanel.this.textField.getText();
                StartGeneratorPanel.this.btnNewButton.setEnabled(false);
                parent.setTabbedPaneEnabled(false);
                StartGeneratorPanel.this.genThreadThread = new Thread(StartGeneratorPanel.this.genThread);
                StartGeneratorPanel.this.genThreadThread.start();
            }
        });
    }

    private class GenThread
    implements Runnable {
        @Override
        public void run() {
            try {
                File plugindataFolder;
                int n;
                int totalCelestialBodies = 6 + StartGeneratorPanel.this.gen.getMinorMoonCount();
                StartGeneratorPanel.this.lblStatus.setText("Status: Deleting Kopernicus cache");
                StartGeneratorPanel.this.progressBar.setValue(0);
                File cacheFolder = new File(String.valueOf(new File(SystemGenerator.plugindataPath).getParentFile().getPath()) + "/cache");
                if (cacheFolder.exists() && cacheFolder.isDirectory()) {
                    File[] fileArray = cacheFolder.listFiles();
                    n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File f = fileArray[n2];
                        System.out.println(f.getName());
                        f.delete();
                        ++n2;
                    }
                }
                if ((plugindataFolder = new File(SystemGenerator.plugindataPath)).exists() && plugindataFolder.isDirectory()) {
                    File[] fileArray = plugindataFolder.listFiles();
                    int n3 = fileArray.length;
                    n = 0;
                    while (n < n3) {
                        File f = fileArray[n];
                        f.delete();
                        ++n;
                    }
                }
                StartGeneratorPanel.this.lblStatus.setText("Status: Generating Planet 9");
                StartGeneratorPanel.this.gen.genP9();
                int i = 0;
                while (i < 5) {
                    StartGeneratorPanel.this.lblStatus.setText("Status: Generating major moon " + Integer.toString(i + 1) + " out of 5");
                    StartGeneratorPanel.this.gen.genMajorMoonMaps(i);
                    double progress = Math.ceil((double)(i + 1 + 1) / (double)totalCelestialBodies * 100.0);
                    StartGeneratorPanel.this.progressBar.setValue((int)progress);
                    ++i;
                }
                File kopernicusFolder = new File(String.valueOf(new File(SystemGenerator.plugindataPath).getParentFile().getPath()) + "/KopernicusConfigs/minor_moons");
                if (kopernicusFolder.exists() && kopernicusFolder.isDirectory()) {
                    File[] fileArray = kopernicusFolder.listFiles();
                    int n4 = fileArray.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        File f = fileArray[n5];
                        f.delete();
                        ++n5;
                    }
                }
                int i2 = 0;
                while (i2 < StartGeneratorPanel.this.gen.getMinorMoonCount()) {
                    StartGeneratorPanel.this.lblStatus.setText("Status: Generating Kopernicus config for minor moon " + Integer.toString(i2 + 1) + " out of " + Integer.toString(StartGeneratorPanel.this.gen.getMinorMoonCount()));
                    StartGeneratorPanel.this.gen.buildMinorMoonKopConfig(i2);
                    StartGeneratorPanel.this.lblStatus.setText("Status: Generating minor moon " + Integer.toString(i2 + 1) + " out of " + Integer.toString(StartGeneratorPanel.this.gen.getMinorMoonCount()));
                    StartGeneratorPanel.this.gen.genMinorMoonMaps(i2);
                    double progress = Math.ceil((double)(i2 + 1 + 5 + 1) / (double)totalCelestialBodies * 100.0);
                    StartGeneratorPanel.this.progressBar.setValue((int)progress);
                    ++i2;
                }
                StartGeneratorPanel.this.lblStatus.setText("Status: Idle");
                StartGeneratorPanel.this.parent.setTabbedPaneEnabled(true);
                StartGeneratorPanel.this.btnNewButton.setEnabled(true);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(GenMain.frame, "Error running the generators: " + e.getMessage(), "Error", 0);
                e.printStackTrace();
                System.exit(1);
            }
        }
    }
}

