/*
 * Decompiled with CFR 0.152.
 */
package tholin.planet9.gens;

import edu.cornell.lassp.houle.RngPack.RanMT;
import java.awt.Color;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import theGhastModding.planetGen.generators.AsteroidMoonGen;
import theGhastModding.planetGen.generators.GeneratorResult;
import theGhastModding.planetGen.generators.GraymoonGen;
import theGhastModding.planetGen.noise.OctaveNoise3D;
import theGhastModding.planetGen.noise.OctaveWorley;
import theGhastModding.planetGen.utils.CraterDistributer;
import theGhastModding.planetGen.utils.MapUtils;
import tholin.planet9.gens.ConfigTemplate;
import tholin.planet9.gens.GenMain;

public class SystemGenerator {
    public static String plugindataPath = "../PluginData";
    private final String packName = "Planet9";
    private GraymoonGen.GraymoonGenSettings p9Settings;
    private long p9Seed = 3526426346L;
    private GraymoonGen.GraymoonGenSettings[] majorMoons;
    private long[] majorMoonSeeds;
    private String[] majorMoonNames = Arrays.copyOf(majorMoonInternalNames, majorMoonInternalNames.length);
    private int minorMoonCount;
    private long minorMoonOrbitsSeed;
    private long minorMoonShapeSeed;
    private List<ConfigTemplate> minorMoonKopConfigs;
    private List<AsteroidMoonGen.AsteroidGenSettings> minorMoonGenConfigs;
    private boolean configsPrepared = false;
    private static final int[] p9MajorMoonRadii = new int[]{233000, 305000, 379000, 114000, 120000};
    private static final String[] majorMoonInternalNames = new String[]{"3118", "2352", "4001", "463", "124"};
    private static final double minorMoonPeri = 2.0E8;
    private static final double minorMoonApo = 5.0E10;
    private static final double minorMoonMinmass = 5.0E14;
    private static final double minorMoonMaxmass = 3.0E17;
    private static final double minorMoonMindensity = 13496.328;
    private static final double minorMoonMaxdensity = 28740.754;
    private final String minorMoonTemplate;
    private static Color[] asteroidColors = new Color[]{new Color(58, 54, 56), new Color(159, 159, 159), new Color(223, 219, 210), new Color(192, 192, 192), new Color(112, 106, 106), new Color(158, 171, 170), new Color(64, 82, 83), new Color(76, 61, 61), new Color(83, 64, 64), new Color(146, 104, 88), new Color(146, 104, 88), new Color(78, 59, 44), new Color(115, 46, 26), new Color(115, 46, 26), new Color(108, 101, 90), new Color(116, 79, 73), new Color(228, 219, 230), new Color(60, 42, 22), new Color(50, 41, 32), new Color(217, 204, 185), new Color(230, 207, 175), new Color(152, 179, 184)};

    public SystemGenerator(int minorMoonCount) {
        this.minorMoonCount = minorMoonCount;
        this.p9Settings = new GraymoonGen.GraymoonGenSettings();
        this.loadDefaultP9Settings();
        this.majorMoons = new GraymoonGen.GraymoonGenSettings[5];
        this.majorMoonSeeds = new long[this.majorMoons.length];
        Random rng = new Random(436457346723L);
        int i = 0;
        while (i < this.majorMoons.length) {
            this.majorMoonSeeds[i] = rng.nextLong();
            ++i;
        }
        this.minorMoonOrbitsSeed = rng.nextLong();
        this.minorMoonShapeSeed = rng.nextLong();
        this.minorMoonKopConfigs = new ArrayList<ConfigTemplate>();
        this.minorMoonGenConfigs = new ArrayList<AsteroidMoonGen.AsteroidGenSettings>();
        String s = "";
        try {
            s = Files.readString(new File("minorMoonTemplate.cfg_").toPath());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(GenMain.frame, "Error loading minor moon Kopernicus config template: " + e.getLocalizedMessage(), "Error", 0);
            e.printStackTrace();
            System.exit(1);
        }
        this.minorMoonTemplate = s;
    }

    public void prepareInitialConfigs() {
        if (this.configsPrepared) {
            System.out.println("[WARNING]: Something tried to call prepareInitialConfigs on the same instance of SystemGenerator more then once. This is most likely a bug.");
            return;
        }
        this.configsPrepared = true;
        int i = 0;
        while (i < this.majorMoons.length) {
            this.majorMoons[i] = this.randomGraymoonSettings(this.majorMoonSeeds[i], p9MajorMoonRadii[i]);
            if (i == 1) {
                this.majorMoons[i].normalColor = new double[]{0.757, 0.819, 0.814};
                this.majorMoons[i].mariasColor = new double[]{0.4989237533816855, 0.5399744419510646, 0.536816696676497};
            }
            ++i;
        }
        this.genAsteroidOrbits();
    }

    public void genAsteroidOrbits() {
        this.minorMoonKopConfigs.clear();
        Random rng = new Random(this.minorMoonOrbitsSeed);
        int i = 0;
        while (i < this.minorMoonCount) {
            String name = String.valueOf(Integer.toHexString(rng.nextInt(65536)).toUpperCase()) + "x";
            double mass = CraterDistributer.biasFunction(Math.min(1.0, Math.abs(rng.nextGaussian() * 0.75)), 0.5) * 2.995E17 + 5.0E14;
            double density = rng.nextDouble() * 15244.426000000001 + 13496.328;
            double radius = Math.pow(mass / density / 4.1887902047863905, 0.3333333333333333);
            double inclination = 2.5 + CraterDistributer.biasFunction(rng.nextDouble(), 0.25) * 45.0 * (rng.nextBoolean() ? -1.0 : 1.0);
            double eccentricity = Math.min(0.9, CraterDistributer.biasFunction(rng.nextDouble(), 0.5));
            double minSMA = -(2.0E8 / (eccentricity - 1.0));
            double maxSMA = 5.0E10 / (1.0 + eccentricity);
            double SMA = CraterDistributer.biasFunction(rng.nextDouble(), 0.5) * (maxSMA - minSMA) + minSMA;
            double LAN = (double)rng.nextInt(360) + rng.nextDouble();
            double AOP = (double)rng.nextInt(360) + rng.nextDouble();
            int g = rng.nextInt(191) + 64;
            ConfigTemplate conf = new ConfigTemplate(name, "Planet9", radius, mass, 3000 + rng.nextInt(10000), "P9", inclination, eccentricity, SMA, LAN, AOP, rng.nextDouble(), 0.0, new Color(g, g, g), this.minorMoonTemplate, ConfigTemplate.ConfigType.ASTEROID);
            conf.setColormap("Planet9/PluginData/" + name + "_colors.png");
            conf.setHeightmap("Planet9/PluginData/" + name + "_height.png");
            conf.setNormals("Planet9/PluginData/" + name + "_normals.png");
            conf.setBiomes("Planet9/PluginData/" + name + "_biomes.png");
            conf.setDeformity((int)(10000.0 * (radius / 15000.0)));
            this.minorMoonKopConfigs.add(conf);
            ++i;
        }
        this.genAsteroidGeneratorConfigs();
    }

    public void genAsteroidGeneratorConfigs() {
        this.minorMoonGenConfigs.clear();
        Random rng = new Random(this.minorMoonShapeSeed);
        int i = 0;
        while (i < this.minorMoonCount) {
            this.minorMoonGenConfigs.add(this.randomAsteroidSettings(rng.nextLong(), (int)Math.ceil(this.minorMoonKopConfigs.get(i).getRadius())));
            ++i;
        }
    }

    public void changeConfigSeed(int idx, long newSeed) {
        this.majorMoonSeeds[idx] = newSeed;
        this.majorMoons[idx] = this.randomGraymoonSettings(this.majorMoonSeeds[idx], p9MajorMoonRadii[idx]);
    }

    public long getConfigSeed(int idx) {
        return this.majorMoonSeeds[idx];
    }

    public GraymoonGen.GraymoonGenSettings getConfig(int idx) {
        return this.majorMoons[idx];
    }

    public int getMajorMoonRadius(int idx) {
        return p9MajorMoonRadii[idx];
    }

    public long getMinorMoonOrbitsSeed() {
        return this.minorMoonOrbitsSeed;
    }

    public long getMinorMoonShapeSeed() {
        return this.minorMoonShapeSeed;
    }

    public void changeMinorMoonOrbitsSeed(long newSeed) {
        this.minorMoonOrbitsSeed = newSeed;
        this.genAsteroidGeneratorConfigs();
    }

    public void changeMinorMoonShapeSeed(long newSeed) {
        this.minorMoonShapeSeed = newSeed;
        this.genAsteroidGeneratorConfigs();
    }

    public int getMinorMoonCount() {
        return this.minorMoonCount;
    }

    public AsteroidMoonGen.AsteroidGenSettings getMinorMoonGenConfig(int idx) {
        return this.minorMoonGenConfigs.get(idx);
    }

    public ConfigTemplate getMinorMoonKopConfig(int idx) {
        return this.minorMoonKopConfigs.get(idx);
    }

    public GraymoonGen.GraymoonGenSettings getP9Settings() {
        return this.p9Settings;
    }

    public long getP9Seed() {
        return this.p9Seed;
    }

    public void changeP9Seed(long seed) {
        this.p9Seed = seed;
    }

    public GeneratorResult genP9PreviewMaps() throws Exception {
        int origWidth = this.p9Settings.width;
        int origHeight = this.p9Settings.height;
        this.p9Settings.width = 512;
        this.p9Settings.height = 256;
        RanMT rng = new RanMT().seedCompletely(this.p9Seed);
        GeneratorResult res = GraymoonGen.generate(rng, this.p9Settings, true, false, false);
        this.p9Settings.width = origWidth;
        this.p9Settings.height = origHeight;
        return res;
    }

    public GeneratorResult genMajorMoonPreviewMaps(int idx) throws Exception {
        int origWidth = this.majorMoons[idx].width;
        int origHeight = this.majorMoons[idx].height;
        this.majorMoons[idx].width = 512;
        this.majorMoons[idx].height = 256;
        RanMT rng = new RanMT().seedCompletely(this.majorMoonSeeds[idx]);
        GeneratorResult res = GraymoonGen.generate(rng, this.majorMoons[idx], true, false, false);
        this.majorMoons[idx].width = origWidth;
        this.majorMoons[idx].height = origHeight;
        return res;
    }

    public void genMajorMoonMaps(int idx) throws Exception {
        RanMT rng = new RanMT().seedCompletely(this.majorMoonSeeds[idx]);
        GeneratorResult res = GraymoonGen.generate(rng, this.majorMoons[idx], true, false, false);
        ImageIO.write((RenderedImage)res.heightmap16, "png", new File(String.valueOf(plugindataPath) + "/" + majorMoonInternalNames[idx] + "_height.png"));
        ImageIO.write((RenderedImage)res.colorMap, "png", new File(String.valueOf(plugindataPath) + "/" + majorMoonInternalNames[idx] + "_colors.png"));
        ImageIO.write((RenderedImage)res.biomeMap, "png", new File(String.valueOf(plugindataPath) + "/" + majorMoonInternalNames[idx] + "_biomes.png"));
        ImageIO.write((RenderedImage)MapUtils.generateNormalMap(res.heightmapRaw, this.majorMoons[idx].planetRadius, 10000.0, 0.33333), "png", new File(String.valueOf(plugindataPath) + "/" + majorMoonInternalNames[idx] + "_normals.png"));
        File kopFile = new File(String.valueOf(plugindataPath) + "/../KopernicusConfigs/" + majorMoonInternalNames[idx] + ".cfg");
        String s = Files.readString(kopFile.toPath());
        s = s.replaceFirst("\t+displayMame = .+", "\t\tdisplayName = " + this.majorMoonNames[idx] + "^N");
        Files.writeString(kopFile.toPath(), (CharSequence)s, new OpenOption[0]);
    }

    public GeneratorResult genMinorMoonPreviewMaps(int idx) throws Exception {
        AsteroidMoonGen.AsteroidGenSettings ags = this.minorMoonGenConfigs.get(idx);
        int origWidth = ags.width;
        int origHeight = ags.height;
        ags.width = 512;
        ags.height = 256;
        Random rng1 = new Random(this.minorMoonShapeSeed);
        long seed = rng1.nextLong();
        if (idx != 0) {
            int i = 0;
            while (i < idx) {
                seed = rng1.nextLong();
                ++i;
            }
        }
        RanMT rng = new RanMT().seedCompletely(seed);
        GeneratorResult res = AsteroidMoonGen.generate(rng, ags, true, false, false);
        ags.width = origWidth;
        ags.height = origHeight;
        return res;
    }

    public void buildMinorMoonKopConfig(int idx) throws Exception {
        File kopernicusFolder = new File(String.valueOf(new File(plugindataPath).getParentFile().getPath()) + "/KopernicusConfigs/minor_moons");
        if (!kopernicusFolder.exists()) {
            kopernicusFolder.mkdirs();
        }
        File outfile = new File(String.valueOf(kopernicusFolder.getPath()) + "/" + this.minorMoonKopConfigs.get(idx).getName() + ".cfg");
        BufferedWriter bw = new BufferedWriter(new FileWriter(outfile));
        bw.write(this.minorMoonKopConfigs.get(idx).buildKopernicusConfig());
        bw.newLine();
        bw.close();
    }

    public void genMinorMoonMaps(int idx) throws Exception {
        Random rng1 = new Random(this.minorMoonShapeSeed);
        long seed = rng1.nextLong();
        if (idx != 0) {
            int i = 0;
            while (i < idx) {
                seed = rng1.nextLong();
                ++i;
            }
        }
        RanMT rng = new RanMT().seedCompletely(seed);
        GeneratorResult res = AsteroidMoonGen.generate(rng, this.minorMoonGenConfigs.get(idx), true, false, false);
        String name = this.minorMoonKopConfigs.get(idx).getName();
        ImageIO.write((RenderedImage)res.heightmap16, "png", new File(String.valueOf(plugindataPath) + "/" + name + "_height.png"));
        ImageIO.write((RenderedImage)res.colorMap, "png", new File(String.valueOf(plugindataPath) + "/" + name + "_colors.png"));
        ImageIO.write((RenderedImage)res.biomeMap, "png", new File(String.valueOf(plugindataPath) + "/" + name + "_biomes.png"));
        ImageIO.write((RenderedImage)MapUtils.generateNormalMap(res.heightmapRaw, this.minorMoonGenConfigs.get((int)idx).planetRadius, 10000.0, 0.33333), "png", new File(String.valueOf(plugindataPath) + "/" + name + "_normals.png"));
    }

    public void genP9() throws Exception {
        if (!new File(plugindataPath).isDirectory()) {
            throw new Exception("The PluginData directory was not found or is not a directory.");
        }
        GeneratorResult res = GraymoonGen.generate(new Random(this.p9Seed), this.p9Settings, true, false, false);
        ImageIO.write((RenderedImage)res.heightmap16, "png", new File(String.valueOf(plugindataPath) + "/P9_height.png"));
        ImageIO.write((RenderedImage)res.colorMap, "png", new File(String.valueOf(plugindataPath) + "/P9_colors.png"));
        ImageIO.write((RenderedImage)res.biomeMap, "png", new File(String.valueOf(plugindataPath) + "/P9_biomes.png"));
        ImageIO.write((RenderedImage)MapUtils.generateNormalMap(res.heightmapRaw, 1068000.0, 10000.0, 1.1), "png", new File(String.valueOf(plugindataPath) + "/P9_normals.png"));
    }

    private void loadDefaultP9Settings() {
        this.p9Settings.width = GenMain.LOWMEM ? 6144 : 8192;
        this.p9Settings.height = GenMain.LOWMEM ? 3072 : 4096;
        this.p9Settings.planetRadius = 400000;
        this.p9Settings.smallCraterCount = 128;
        this.p9Settings.hugeCraterCount = 4;
        this.p9Settings.craterMaxsize = 64.0;
        this.p9Settings.craterMaxstrength = 0.3;
        this.p9Settings.mariaCraterMaxsize = 16.0;
        this.p9Settings.mariaCraterMaxstrength = 0.2;
        this.p9Settings.craterFlattenedStart = 20;
        this.p9Settings.mariaCraterCount = 1;
        this.p9Settings.mariaNoise.noise = new OctaveNoise3D(16, 16, 16, 7, 2.0, 0.67);
        this.p9Settings.mariaNoise.setDistortStrength(0.5).setNoiseOffset(0.15);
        this.p9Settings.mariaLatitudeRange = 91.0;
        this.p9Settings.mariaLongitudeRange = 181.0;
        this.p9Settings.secondColorNoise.noise = new OctaveNoise3D(16, 16, 16, 5, 2.0, 0.7);
        this.p9Settings.secondColorNoise.setDistortStrength(0.75).setNoiseOffset(0.325).setNoiseStrength(1.2);
        this.p9Settings.secondaryColor = MapUtils.RGB(new Color(170, 170, 170));
        this.p9Settings.biomeColorSecondary = MapUtils.RGB(Color.WHITE);
        this.p9Settings.mariasColor = MapUtils.RGB(new Color(38, 28, 25));
        this.p9Settings.normalColor = MapUtils.RGB(new Color(148, 110, 97));
        this.p9Settings.mountainsColor = MapUtils.RGB(new Color(114, 59, 43));
        double mScale = this.p9Settings.mountainNoise.noiseLatitudeScale * 0.85;
        this.p9Settings.mountainNoise.setNoiseLatitudeScale(mScale).setNoiseLongitudeScale(mScale * 0.85);
        this.p9Settings.groundNoiseLargeDetail.setNoiseScale(this.p9Settings.groundNoiseLargeDetail.noiseLatitudeScale * 0.25);
        this.p9Settings.groundNoiseMediumDetail.setNoiseScale(this.p9Settings.groundNoiseMediumDetail.noiseLatitudeScale * 0.25);
        this.p9Settings.groundNoiseSmallDetail.setNoiseScale(this.p9Settings.groundNoiseSmallDetail.noiseLatitudeScale * 0.25);
        this.p9Settings.groundNoiseLargeDetail.noiseStrength *= 0.8;
    }

    private GraymoonGen.GraymoonGenSettings randomGraymoonSettings(long seed, int radius) {
        GraymoonGen.GraymoonGenSettings settings = new GraymoonGen.GraymoonGenSettings();
        Random rng = new Random(seed);
        settings.width = GenMain.LOWMEM ? 6144 : 8192;
        settings.height = GenMain.LOWMEM ? 3072 : 4096;
        settings.planetRadius = radius;
        double craterStrengthMul = (double)settings.planetRadius / 150000.0;
        if (craterStrengthMul > 1.0) {
            craterStrengthMul = 1.0;
        }
        settings.craterMaxstrength *= craterStrengthMul;
        settings.craterMinstrength *= craterStrengthMul;
        settings.mariaCraterMaxstrength *= craterStrengthMul;
        settings.mariaCraterMinstrength *= craterStrengthMul;
        if (rng.nextInt(3) == 0) {
            settings.mariaLongitudeRange = 181.0;
            settings.mariaLatitudeRange = 91.0;
            settings.mariaCraterCount = 3 + rng.nextInt(7);
        } else {
            settings.mariaLongitudeRange = -181.0;
            settings.mariaLatitudeRange = -91.0;
            settings.mariaCraterCount = 0;
        }
        if (rng.nextBoolean()) {
            settings.secondColorNoise.setIsRidged(false);
        } else {
            settings.secondColorNoise.noiseOffset -= rng.nextDouble() * 0.2;
        }
        settings.secondColorNoise.setNoiseScale(settings.secondColorNoise.noiseLatitudeScale * (1.0 + rng.nextDouble() * 0.9 - 0.45));
        settings.hugeCraterCount = Math.max(0, rng.nextInt(12) - 1);
        settings.smallCraterCount = rng.nextInt(24576) + 32;
        if (rng.nextInt(3) != 0) {
            settings.normalColor = MapUtils.RGB(asteroidColors[rng.nextInt(asteroidColors.length)]);
            settings.mountainsColor = MapUtils.RGB(asteroidColors[rng.nextInt(asteroidColors.length)]);
            if (rng.nextBoolean()) {
                settings.mariasColor = MapUtils.RGB(asteroidColors[rng.nextInt(asteroidColors.length)]);
            } else if (rng.nextInt(3) != 0) {
                double mul = 0.25 + rng.nextDouble() * 0.4;
                settings.mariasColor[0] = settings.normalColor[0] * mul;
                settings.mariasColor[1] = settings.normalColor[1] * mul;
                settings.mariasColor[2] = settings.normalColor[2] * mul;
            }
            settings.secondaryColor = rng.nextBoolean() ? MapUtils.RGB(asteroidColors[rng.nextInt(asteroidColors.length)]) : settings.normalColor;
        }
        SystemGenerator.randomnizeColor(settings.normalColor, 0.5, rng);
        SystemGenerator.randomnizeColor(settings.mountainsColor, 0.5, rng);
        SystemGenerator.randomnizeColor(settings.mariasColor, 0.5, rng);
        SystemGenerator.randomnizeColor(settings.secondaryColor, 0.5, rng);
        if (rng.nextBoolean()) {
            settings.mountainsNoise.setIsRidged(true);
            settings.craterMountainsNoise.setIsRidged(true);
        }
        settings.mountainsNoise.setNoiseScale(settings.mountainsNoise.noiseLatitudeScale + (rng.nextDouble() * 2.0 - 1.0) * 0.2);
        settings.craterMountainsNoise.setNoiseScale(settings.mountainsNoise.noiseLatitudeScale);
        double offset = rng.nextDouble() * 1.5 - 1.0;
        settings.mountainsNoise.noiseStrength += offset;
        settings.craterMountainsNoise.noiseStrength += offset;
        settings.mountainsNoise.distortStrength += rng.nextDouble() * 0.4 - 0.2;
        settings.craterMountainsNoise.distortStrength += rng.nextDouble() * 0.8 - 0.4;
        if (rng.nextBoolean()) {
            settings.mountainNoise.noiseStrength += rng.nextDouble() * 0.2 - 0.1;
        } else {
            settings.mountainNoise.setNoiseScale(settings.mountainNoise.noiseLatitudeScale + (rng.nextDouble() * 2.0 - 1.0) * 0.8);
        }
        if (rng.nextBoolean()) {
            settings.mountainNoise.setNoiseLongitudeScale(settings.mountainNoise.noiseLatitudeScale * (0.8 + rng.nextDouble() * 0.2));
        }
        settings.mountainNoise.distortStrength += rng.nextDouble() * 0.45 - 0.1;
        settings.colorNoise.distortStrength = rng.nextDouble() * 0.58 + 0.4;
        if (rng.nextBoolean()) {
            settings.colorNoise.noise = new OctaveWorley(32, 32, 32, 9 + rng.nextInt(3), 2.0, 0.75 + (rng.nextDouble() * 2.0 - 1.0) * 0.15);
        }
        double scale = settings.groundNoiseLargeDetail.noiseLatitudeScale;
        settings.groundNoiseLargeDetail.setNoiseScale(scale + (rng.nextDouble() * 2.0 - 1.0) * 0.4 * scale);
        scale = settings.groundNoiseMediumDetail.noiseLatitudeScale;
        settings.groundNoiseMediumDetail.setNoiseScale(scale + (rng.nextDouble() * 2.0 - 1.0) * 0.4 * scale);
        scale = settings.groundNoiseSmallDetail.noiseLatitudeScale;
        settings.groundNoiseSmallDetail.setNoiseScale(scale + (rng.nextDouble() * 2.0 - 1.0) * 0.4 * scale);
        settings.mariaNoise.setNoiseScale(1.5462);
        settings.mariaNoise.distortStrength = 0.3726;
        if (rng.nextInt(4) != 0) {
            scale = settings.mariaNoise.noiseLatitudeScale;
            settings.mariaNoise.setNoiseScale(scale + (rng.nextDouble() * 2.0 - 1.0) * 0.7 * scale);
            settings.mariaNoise.distortStrength += rng.nextDouble() * 0.75 - 0.1;
            settings.mariaNoise.noise = new OctaveNoise3D(16, 16, 16, 5 + rng.nextInt(5), 2.0 + (rng.nextDouble() * 2.0 - 1.0) * 0.5, 0.5 + rng.nextDouble() * 0.4);
        }
        if (rng.nextBoolean()) {
            settings.groundNoiseLargeDetail.setIsRidged(true);
            settings.groundNoiseLargeDetail.setNoiseOffset(0.1 * rng.nextDouble());
        }
        if (rng.nextBoolean()) {
            settings.craterMaxsize = 64 + rng.nextInt(72);
            settings.craterMinsize += (double)(rng.nextInt(4) - 2);
            settings.mariaCraterMaxsize = 24 + rng.nextInt(12);
        }
        settings.craterMaxsize *= 1.0 + (1.0 - (double)settings.planetRadius / 200000.0);
        settings.craterMinsize *= 1.0 + (1.0 - (double)settings.planetRadius / 200000.0);
        if (rng.nextBoolean()) {
            double mul = 1.0 + rng.nextDouble() * 0.3 - 0.15;
            settings.craterRimFades[0] = settings.craterRimFades[0] * mul;
            settings.craterRimFades[1] = settings.craterRimFades[1] * mul;
            settings.craterRimFades[2] = settings.craterRimFades[2] * mul;
            mul = 1.0 + rng.nextDouble() * 0.4 - 0.2;
            settings.mariaCraterRimFades[0] = settings.mariaCraterRimFades[0] * mul;
            settings.mariaCraterRimFades[1] = settings.mariaCraterRimFades[1] * mul;
            settings.mariaCraterRimFades[2] = settings.mariaCraterRimFades[2] * mul;
        }
        settings.mariaCraterMaxstrength *= (double)settings.planetRadius / 200000.0;
        settings.mariaCraterMinstrength *= (double)settings.planetRadius / 200000.0;
        return settings;
    }

    private AsteroidMoonGen.AsteroidGenSettings randomAsteroidSettings(long seed, int radius) {
        AsteroidMoonGen.AsteroidGenSettings settings = new AsteroidMoonGen.AsteroidGenSettings();
        Random rng = new Random(seed);
        settings.planetRadius = 20000;
        settings.width = 8192;
        settings.height = 4096;
        double craterStrengthMul = (double)settings.planetRadius / 20000.0;
        if (craterStrengthMul > 1.0) {
            craterStrengthMul = 1.0;
        }
        settings.craterMaxstrength *= craterStrengthMul;
        settings.craterMinstrength *= craterStrengthMul;
        settings.normalColor = MapUtils.RGB(asteroidColors[rng.nextInt(asteroidColors.length)]);
        settings.peaksColor = MapUtils.RGB(asteroidColors[rng.nextInt(asteroidColors.length)]);
        settings.secondaryColor = rng.nextBoolean() ? MapUtils.RGB(asteroidColors[rng.nextInt(asteroidColors.length)]) : settings.normalColor;
        if (rng.nextBoolean()) {
            SystemGenerator.randomnizeColor(settings.normalColor, 0.5, rng);
        }
        if (rng.nextBoolean()) {
            SystemGenerator.randomnizeColor(settings.peaksColor, 0.5, rng);
        }
        if (rng.nextBoolean()) {
            SystemGenerator.randomnizeColor(settings.secondaryColor, 0.5, rng);
        }
        if (rng.nextBoolean()) {
            settings.ridgedShape = true;
            settings.shapeNoise.setIsRidged(true);
            settings.shapeNoise.setNoiseOffset(0.078);
        } else if (rng.nextBoolean()) {
            settings.shapeNoise.noiseOffset += (rng.nextDouble() * 2.0 - 1.0) * 0.1;
        }
        settings.shapeNoise.setNoiseScale(1.5 + rng.nextDouble() * 1.0);
        settings.shapeNoise.noiseStrength += (rng.nextDouble() * 2.0 - 1.0) * 0.35;
        settings.shapeNoise.noise = new OctaveNoise3D(16, 16, 16, 3 + rng.nextInt(2), 2.0 + rng.nextDouble() - 0.5, 0.32 + rng.nextDouble() * 0.4 - 0.1);
        if (rng.nextBoolean()) {
            settings.shapeNoise.setNoiseLatitudeScale(settings.shapeNoise.noiseLongitudeScale * (0.8 + 0.2 * rng.nextDouble()));
        }
        if (rng.nextBoolean()) {
            settings.groundNoise.setIsRidged(true);
            settings.groundNoise.setNoiseOffset(rng.nextDouble() * 0.1);
        } else {
            settings.groundNoise.noiseOffset -= rng.nextDouble() * 0.15;
        }
        if (rng.nextBoolean()) {
            settings.secondColorNoise.setIsRidged(true);
            settings.secondColorNoise.setNoiseOffset(0.0);
        }
        double scale = settings.secondColorNoise.noiseLatitudeScale;
        settings.secondColorNoise.setNoiseScale(scale + (rng.nextDouble() * 2.0 - 1.0) * 0.4 * scale);
        scale = settings.groundNoise.noiseLatitudeScale;
        settings.groundNoise.setNoiseScale(scale + (rng.nextDouble() * 2.0 - 1.0) * 0.25 * scale);
        scale = settings.peakNoise.noiseLatitudeScale;
        settings.peakNoise.setNoiseScale(scale + (rng.nextDouble() * 2.0 - 1.0) * 0.25 * scale);
        if (rng.nextBoolean()) {
            settings.secondColorNoise.noise = new OctaveNoise3D(16, 16, 16, 2 + rng.nextInt(2), 2.0 + (rng.nextDouble() * 0.2 - 0.1), 0.5 + rng.nextDouble() * 0.1);
        }
        if (rng.nextBoolean()) {
            settings.craterMaxsize = 96 + rng.nextInt(48);
            settings.craterMinsize += (double)(rng.nextInt(4) - 2);
        }
        settings.craterCount = 24 + rng.nextInt(768);
        return settings;
    }

    private static double[] randomnizeColor(double[] col, double amount, Random rng) {
        double u = rng.nextDouble();
        col[0] = col[0] + (u * 2.0 - 1.0) * amount * col[0];
        col[1] = col[1] + (u * 2.0 - 1.0) * amount * col[1];
        col[2] = col[2] + (u * 2.0 - 1.0) * amount * col[2];
        col[0] = Math.min(1.0, Math.max(0.0, col[0]));
        col[1] = Math.min(1.0, Math.max(0.0, col[1]));
        col[2] = Math.min(1.0, Math.max(0.0, col[2]));
        return col;
    }
}

