#include <stdint.h>

#include "planet.h"
#include "avali_system.h"

planet solakku;
planet valaya;
planet valayaMoons[6];
void init_avali_system() {
	solakku.parent = (void*)0;
	solakku.children = &valaya;
	solakku.child_count = 1;
	solakku.rotationPeriod = 10000;
	solakku.mass = 3.08213935E30;
	solakku.radius = 1.08499248E9;
	solakku.isTidallyLocked = 0;
	solakku.anomalyAtEpoch = 0;
	solakku.axisRotation = 0;
	solakku.initialized = 1;
	valaya.parent = &solakku;
	valaya.children = valayaMoons;
	valaya.child_count = 6;
	valaya.AOP = 309.71;
	valaya.LAN = 195;
	valaya.SMA = 959969724300.0;
	valaya.anomalyAtEpoch = 0;
	valaya.eccentricity = 0.01;
	valaya.inclination = -0.14;
	valaya.initialized = 0;
	valaya.isTidallyLocked = 0;
	valaya.mass = 1.28398E27;
	valaya.radius = 29625150;
	valaya.rotationPeriod = 2*24*60*60+13*60*60+52*60+30;
	
	valayaMoons[0].parent = &valaya;
	valayaMoons[0].children = (void*)0;
	valayaMoons[0].child_count = 0;
	valayaMoons[0].AOP = 350.261815965646;
	valayaMoons[0].LAN = 0;
	valayaMoons[0].SMA = 136590804.925329131;
	valayaMoons[0].anomalyAtEpoch = 0;
	valayaMoons[0].eccentricity = 0.0511068770419507;
	valayaMoons[0].inclination = 0;
	valayaMoons[0].initialized = 0;
	valayaMoons[0].isTidallyLocked = 1;
	valayaMoons[0].mass = 1.60631441893855E22;
	valayaMoons[0].radius = 901127.925329131;

	valayaMoons[1].parent = &valaya;
	valayaMoons[1].children = (void*)0;
	valayaMoons[1].child_count = 0;
	valayaMoons[1].AOP = 352.15836130309;
	valayaMoons[1].LAN = 0;
	valayaMoons[1].SMA = 223878046.138109;
	valayaMoons[1].anomalyAtEpoch = 0;
	valayaMoons[1].eccentricity = 0.0302916001043635;
	valayaMoons[1].inclination = 0;
	valayaMoons[1].initialized = 0;
	valayaMoons[1].isTidallyLocked = 1;
	valayaMoons[1].mass = 2.08733963649925E22;
	valayaMoons[1].radius = 957420;
	
	valayaMoons[2].parent = &valaya;
	valayaMoons[2].children = (void*)0;
	valayaMoons[2].child_count = 0;
	valayaMoons[2].AOP = 248.110203215721;
	valayaMoons[2].LAN = 0;
	valayaMoons[2].SMA = 420779017.335923;
	valayaMoons[2].anomalyAtEpoch = 0;
	valayaMoons[2].eccentricity = 0.0567932697699999;
	valayaMoons[2].inclination = 0;
	valayaMoons[2].initialized = 0;
	valayaMoons[2].isTidallyLocked = 1;
	valayaMoons[2].mass = 2.80416485124779E23;
	valayaMoons[2].radius = 2284240;
	
	valayaMoons[3].parent = &valaya;
	valayaMoons[3].children = (void*)0;
	valayaMoons[3].child_count = 0;
	valayaMoons[3].AOP = 234.167694406735;
	valayaMoons[3].LAN = 0;
	valayaMoons[3].SMA = 771568000;
	valayaMoons[3].anomalyAtEpoch = 0;
	valayaMoons[3].eccentricity = 0.018507543492531;
	valayaMoons[3].inclination = 0;
	valayaMoons[3].initialized = 0;
	valayaMoons[3].isTidallyLocked = 1;
	valayaMoons[3].mass = 7.58444E23;
	valayaMoons[3].radius = 4537000;

	valayaMoons[4].parent = &valaya;
	valayaMoons[4].children = (void*)0;
	valayaMoons[4].child_count = 0;
	valayaMoons[4].AOP = 262.861332103929;
	valayaMoons[4].LAN = 0;
	valayaMoons[4].SMA = 1205516683.71379;
	valayaMoons[4].anomalyAtEpoch = 0;
	valayaMoons[4].eccentricity = 0.106741813989062;
	valayaMoons[4].inclination = 0.15;
	valayaMoons[4].initialized = 0;
	valayaMoons[4].isTidallyLocked = 1;
	valayaMoons[4].mass = 4.40864224642125E23;
	valayaMoons[4].radius = 2645880;
	
	valayaMoons[5].parent = &valaya;
	valayaMoons[5].children = (void*)0;
	valayaMoons[5].child_count = 0;
	valayaMoons[5].AOP = 140.7;
	valayaMoons[5].LAN = 27.89;
	valayaMoons[5].SMA = 1898900100;
	valayaMoons[5].anomalyAtEpoch = 0;
	valayaMoons[5].eccentricity = 0.23;
	valayaMoons[5].inclination = -5.7;
	valayaMoons[5].initialized = 0;
	valayaMoons[5].isTidallyLocked = 0;
	valayaMoons[5].rotationPeriod = 5*60*60+57*60+37;
	valayaMoons[5].mass = 4.539E16;
	valayaMoons[5].radius = 21457;
}

void update_avali_system(double time) {
	update_planet(&solakku, time);
}
