#version 330 core

out vec4 FragColor;

in vec2 tex_coords;

void main() {
    //FragColor = vec4(tex_coords.x, tex_coords.y, 0, 1.0f);
    
    float c_im, c_re;
    float man_x = c_re = tex_coords.x * 3 - 1.5;
    float man_y = c_im = tex_coords.y * 2 - 1;
    float man_xx, man_yy, temp;
    
    int iteration = 0;
    while(iteration < 256) {
        man_yy = man_y * man_y;
        temp = man_x * man_y;
        temp += temp;
        man_y = temp + c_im;
        man_xx = man_x * man_x;
        temp = man_xx - man_yy;
        man_x = temp + c_re;
        if(man_xx + man_yy > 4) break;
        iteration++;
    }
    if(iteration == 256) FragColor = vec4(0, 0, 0, 1);
    else {
        temp = min(1, float(iteration) / 64.0f);
        vec3 a = vec3(0.1, 0.3, 1) * temp;
        FragColor = vec4(a, 1);
    }
} 
