#ifndef GLOBAL_H_
#define GLOBAL_H_

#define DEG2RAD ((3.14159265358979f * 2.0f) / 360.0f)

#define W_WIDTH 4096
#define W_HEIGHT 2048

typedef struct {
	GLuint id;
	int width;
	int height;
	int nrChannels;
} texture;

typedef struct {
	float x;
	float y;
	float z;
	float pitch;
	float yaw;
	float roll;
} camera;

#ifndef USE_OSM
static const EGLint configAttribs[] = {
	EGL_SURFACE_TYPE, EGL_PBUFFER_BIT,
	EGL_BLUE_SIZE, 8,
	EGL_GREEN_SIZE, 8,
	EGL_RED_SIZE, 8,
	EGL_DEPTH_SIZE, 16,
	EGL_RENDERABLE_TYPE, EGL_OPENGL_BIT,
	EGL_NONE
};

static const EGLint pbufferAttribs[] = {
	EGL_WIDTH, W_WIDTH,
	EGL_HEIGHT, W_HEIGHT,
	EGL_NONE,
};
#endif

#endif
