#ifndef PLANET_H_
#define PLANET_H_

#define BIG_G 6.67408e-11
#define EPS 1e-4
#define TAU (3.14159265358979+3.14159265358979)

typedef struct {
	double mass, radius;
	double SMA;
	double eccentricity, AOP;
	double inclination, LAN;
	double rotationPeriod;
	uint8_t isTidallyLocked;
	void* parent;
	void* children;
	uint8_t child_count;
	double anomalyAtEpoch;
	double axisRotation;
	
	uint8_t initialized;
	double orbitalPeriod;
	
	double posX,posY,posZ;
	double absX,absY,absZ;
	double pX, pY, pZ, qX, qY, qZ, e2, sqrtGravParamOverSMA, totalMass;
} planet;

void update_planet(planet* p, double time);

#endif
