#version 400 core

in vec3 aPos;

out vec3 rd;
out vec3 rdi;

uniform mat4 projection_matrix;
uniform mat4 view_matrix;
uniform float cam_rot;

vec3 RotateAroundYInDegrees(vec3 vertex, float deg) {
    float alpha = deg * 3.1415926535 / 180.0;
    float sina = sin(alpha), cosa = cos(alpha);
    return vec3(vertex.x * cosa + vertex.z * sina, vertex.y, -vertex.x * sina + vertex.z * cosa);
}

void main() {
    gl_Position = projection_matrix * view_matrix * vec4(aPos, 1.0);
    
    rdi = normalize(aPos.xzy);
    rd = normalize(RotateAroundYInDegrees(aPos.xzy, -cam_rot));
}
