#version 400 core

in vec4 position;
in vec3 nrm;

out vec4 FragColor;

uniform sampler2D steep_tex;
uniform sampler2D grass_tex;
uniform float height_scale;
uniform vec3 light_dir;

void main() {
    vec3 steep_sample = texture(steep_tex, position.xz / 200).rgb * 0.5 + 0.5;
	vec3 grass_sample = texture(grass_tex, position.xz / 50).rgb;
	
	float steepness = 1 - clamp(dot(vec3(0,1,0), nrm), 0, 1);
	steepness = clamp(steepness * 4, 0, 1);
	FragColor = vec4(steepness * steep_sample + (1 - steepness) * grass_sample, 1);
	
    float a = position.y / height_scale;
    if(a > 0.1) {
		a = (a - 0.1) / 0.2;
		a = clamp(a, 0, 1);
		FragColor = a + (1 - a) * FragColor;
	}
	
	float light_str = dot(light_dir, -nrm);
	light_str = clamp(light_str, 0.03, 1);
	FragColor *= light_str;
	
	//FragColor = vec4(nrm, 1);
    FragColor.a = 1;
}
