#version 400 core

in vec3 aPos;
in vec3 aNormal;

out vec4 position;
out vec3 nrm;

uniform mat4 projection_matrix;
uniform mat4 view_matrix;
uniform mat4 transformation_matrix;

void main() {
	position = transformation_matrix * vec4(aPos, 1.0);
    gl_Position = projection_matrix * view_matrix * position;
    nrm = aNormal;
}
