#version 330 core

in vec3 aPos;
in vec2 uv;

out vec2 tex_coords;

uniform mat4 transformation_matrix;
uniform mat4 projection_matrix;
uniform mat4 view_matrix;

void main() {
    gl_Position = projection_matrix * transformation_matrix * view_matrix * vec4(aPos, 1.0);
    tex_coords = uv;
}
