/*
 * Decompiled with CFR 0.152.
 */
package theGhastModding.synthesizer.main;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import jouvieje.bass.Bass;
import jouvieje.bass.BassInit;
import jouvieje.bass.structures.BASS_INFO;
import jouvieje.bass.structures.BASS_MIDI_FONT;
import jouvieje.bass.structures.HSOUNDFONT;
import jouvieje.bass.structures.HSTREAM;
import jouvieje.bass.utils.BufferUtils;
import jouvieje.bass.utils.Pointer;
import theGhastModding.synthesizer.main.MidiEvent;
import theGhastModding.synthesizer.main.SynthesizerException;

public class TGMSynthesizer {
    private static boolean started = false;
    private static int handle = 0;
    private static HSTREAM stream = null;
    private static int maxVoices = 500;
    private static float renderingLimit = 95.0f;
    private static int volume = 100;
    private static final String VERSION = "1.2.0";
    private static int sf = 0;

    public static String getVersion() {
        return VERSION;
    }

    public static float getRenderingTime() throws Exception {
        FloatBuffer fbfr = BufferUtils.newFloatBuffer((int)1);
        Bass.BASS_ChannelGetAttribute((int)handle, (int)7, (FloatBuffer)fbfr);
        return fbfr.get(0);
    }

    public static int getVolume() {
        return volume;
    }

    public static void setVolume(int newVolume) throws Exception {
        volume = newVolume;
        Bass.BASS_SetConfig((int)5, (int)(100 * volume));
    }

    public static float getRenderingLimit() {
        return renderingLimit;
    }

    public static void setRenderingLimit(float newLimit) throws Exception {
        renderingLimit = newLimit;
        Bass.BASS_ChannelSetAttribute((int)handle, (int)73729, (float)newLimit);
    }

    public static int getActiveVoices() throws Exception {
        if (!started) {
            throw new SynthesizerException("Synthesizer isnt started");
        }
        FloatBuffer fbfr = BufferUtils.newFloatBuffer((int)1);
        Bass.BASS_ChannelGetAttribute((int)handle, (int)73732, (FloatBuffer)fbfr);
        float num11 = fbfr.get(0);
        return (int)num11;
    }

    public static Pointer pointerFromString(String s) {
        return BufferUtils.asPointer((Buffer)BufferUtils.fromString((String)s));
    }

    public static int MAKEWORD(byte low, byte high) {
        return high << 8 | low;
    }

    public static void sendEvents(MidiEvent[] events) throws Exception {
        ArrayList<MidiEvent> eventsList = new ArrayList<MidiEvent>();
        MidiEvent[] midiEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            MidiEvent e = midiEventArray[n2];
            eventsList.add(e);
            ++n2;
        }
        TGMSynthesizer.sendEvents(eventsList);
    }

    public static void sendEvents(List<MidiEvent> events) throws Exception {
        if (!started) {
            throw new SynthesizerException("Synthesizer isnt started");
        }
        for (MidiEvent e : events) {
            TGMSynthesizer.sendEvent(e);
        }
    }

    public static void sendEvent(MidiEvent event) throws Exception {
        if (!started) {
            throw new SynthesizerException("Synthesizer isnt started");
        }
        Bass.BASS_MIDI_StreamEvent((HSTREAM)stream, (int)event.getChannel(), (int)event.getID(), (int)TGMSynthesizer.MAKEWORD((byte)event.getValue1(), (byte)event.getValue2()));
    }

    public static void unloadFont(HSOUNDFONT font) throws Exception {
        if (!started) {
            throw new SynthesizerException("Synthesizer isnt started");
        }
        Bass.BASS_MIDI_FontFree((HSOUNDFONT)font);
    }

    public static List<HSOUNDFONT> loadFonts(String[] soundfonts) throws Exception {
        ArrayList<String> fontsList = new ArrayList<String>();
        String[] stringArray = soundfonts;
        int n = soundfonts.length;
        int n2 = 0;
        while (n2 < n) {
            String e = stringArray[n2];
            fontsList.add(e);
            ++n2;
        }
        return TGMSynthesizer.loadFonts(fontsList);
    }

    public static List<HSOUNDFONT> loadFonts(List<String> soundfonts) throws Exception {
        if (!started) {
            throw new SynthesizerException("Synthesizer isnt started");
        }
        ArrayList<HSOUNDFONT> toReturn = new ArrayList<HSOUNDFONT>();
        int i = 0;
        while (i < soundfonts.size()) {
            if (!new File(soundfonts.get(i)).exists()) {
                throw new FileNotFoundException(soundfonts.get(i));
            }
            BASS_MIDI_FONT font = BASS_MIDI_FONT.allocate();
            font.setFont(Bass.BASS_MIDI_FontInit((Pointer)TGMSynthesizer.pointerFromString(soundfonts.get(i)), (int)0));
            font.setPreset(-1);
            font.setBank(0);
            Bass.BASS_MIDI_StreamSetFonts((HSTREAM)stream, (BASS_MIDI_FONT)font, (int)(++sf));
            Bass.BASS_MIDI_StreamLoadSamples((HSTREAM)stream);
            toReturn.add(font.getFont());
            ++i;
        }
        return toReturn;
    }

    public static HSOUNDFONT loadFont(String fontLocation) throws Exception {
        if (!started) {
            throw new SynthesizerException("Synthesizer isnt started");
        }
        if (!new File(fontLocation).exists()) {
            throw new FileNotFoundException(fontLocation);
        }
        BASS_MIDI_FONT font = BASS_MIDI_FONT.allocate();
        font.setFont(Bass.BASS_MIDI_FontInit((Pointer)TGMSynthesizer.pointerFromString(fontLocation), (int)0));
        font.setPreset(0);
        font.setBank(0);
        Bass.BASS_MIDI_StreamSetFonts((HSTREAM)stream, (BASS_MIDI_FONT)font, (int)1);
        Bass.BASS_MIDI_StreamLoadSamples((HSTREAM)stream);
        return font.getFont();
    }

    public static void startSynth(int audioFrequency, boolean mono) throws Exception {
        if (started) {
            throw new SynthesizerException("Synth is allready running");
        }
        BassInit.loadLibraries();
        if (mono) {
            Bass.BASS_Init((int)-1, (int)audioFrequency, (int)2, null, null);
        } else {
            Bass.BASS_Init((int)-1, (int)audioFrequency, (int)256, null, null);
        }
        Bass.BASS_SetConfig((int)1, (int)0);
        Bass.BASS_SetConfig((int)24, (int)32);
        BASS_INFO info = BASS_INFO.allocate();
        Bass.BASS_GetInfo((BASS_INFO)info);
        Bass.BASS_SetConfig((int)0, (int)(info.getMinBuffer() + 10));
        stream = Bass.BASS_MIDI_StreamCreate((int)16, (int)272, (int)audioFrequency);
        handle = stream.asInt();
        started = true;
        TGMSynthesizer.setMaxVoices(500);
        TGMSynthesizer.setUseFx(true);
        TGMSynthesizer.setOnlyReleaseOnOverlapingInstances(false);
        Bass.BASS_ChannelPlay((int)handle, (boolean)false);
        new Thread(new UpdateThread()).start();
    }

    public static void setOnlyReleaseOnOverlapingInstances(boolean b) throws Exception {
        if (!started) {
            throw new SynthesizerException("Synthesizer isnt started");
        }
        if (b) {
            Bass.BASS_ChannelFlags((int)handle, (int)65536, (int)65536);
        } else {
            Bass.BASS_ChannelFlags((int)handle, (int)0, (int)65536);
        }
    }

    public static void setUseFx(boolean useFx) throws Exception {
        if (!started) {
            throw new SynthesizerException("Synthesizer isnt started");
        }
        if (useFx) {
            Bass.BASS_ChannelFlags((int)handle, (int)8192, (int)8192);
        } else {
            Bass.BASS_ChannelFlags((int)handle, (int)0, (int)8192);
        }
    }

    public static int getMaxVoices() {
        return maxVoices;
    }

    public static void setMaxVoices(int newMaxVoices) throws Exception {
        if (!started) {
            throw new SynthesizerException("Synthesizer isnt started");
        }
        maxVoices = newMaxVoices;
        Bass.BASS_ChannelSetAttribute((int)handle, (int)73731, (float)maxVoices);
    }

    public static void stopSynth() throws Exception {
        if (!started) {
            throw new SynthesizerException("Cant stop the synth when it isnt even running");
        }
        started = false;
        Bass.BASS_Free();
    }

    public static boolean isSynthStarted() {
        return started;
    }

    private static class UpdateThread
    implements Runnable {
        private UpdateThread() {
        }

        @Override
        public void run() {
            while (started) {
                Bass.BASS_ChannelUpdate((int)handle, (int)0);
            }
        }
    }
}

