package theGhastModding.GoSBuilder.main;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;

import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JButton;
import javax.swing.SwingConstants;

@SuppressWarnings("serial")
public class AboutDialog extends JDialog {
	
	private BufferedImage background;
	
	public AboutDialog() {
		super(BuilderLogGui.frame, "About");
		setModal(true);
		setLocationRelativeTo(BuilderLogGui.frame);
		setDefaultCloseOperation(JFrame.HIDE_ON_CLOSE);
		getContentPane().setLayout(null);
		getContentPane().setPreferredSize(new Dimension(500,300));
		setResizable(false);
		JLabel backgroundLabel = null;
		try {
			background = ImageIO.read(this.getClass().getResourceAsStream("/free_space_galaxy_texture_by_lyshastra-d77gh54.png"));
			background = BuilderLogGui.resizeImage(background, 500, 300);
			backgroundLabel = new JLabel(new ImageIcon(background));
			backgroundLabel.setBounds(0, 0, 500, 300);
		}catch(Exception e){
			JOptionPane.showMessageDialog(BuilderLogGui.frame, "Error loading background for about dialog", "Error", JOptionPane.ERROR_MESSAGE);
			e.printStackTrace();
			System.exit(1);
		}
		JButton btnOk = new JButton("");
		btnOk.setBounds(201, 265, 89, 23);
		btnOk.setIcon(new ImageIcon(texturedButtonTexture(201,265,89,23,"OK")));
		btnOk.addActionListener(new ActionListener(){
			public void actionPerformed(ActionEvent e){
				setVisible(false);
			}
		});
		getContentPane().add(btnOk);
		
		JLabel lblNewLabel = new JLabel("Hypernova builder by TheGhastModding");
		lblNewLabel.setHorizontalAlignment(SwingConstants.CENTER);
		lblNewLabel.setBounds(10, 11, 480, 14);
		lblNewLabel.setForeground(Color.WHITE);
		getContentPane().add(lblNewLabel);
		
		JLabel lblProgramToBuild = new JLabel("Program to build the MIDI \"Hypernova\" - the mother of all MIDIs");
		lblProgramToBuild.setHorizontalAlignment(SwingConstants.CENTER);
		lblProgramToBuild.setBounds(20, 37, 470, 16);
		lblProgramToBuild.setForeground(Color.WHITE);
		getContentPane().add(lblProgramToBuild);
		
		JLabel lblCredits = new JLabel("Credits: ");
		lblCredits.setForeground(Color.WHITE);
		lblCredits.setBounds(10, 82, 55, 16);
		getContentPane().add(lblCredits);
		
		JLabel lblAboutDialogBackground = new JLabel("About dialog background: lyshastra.deviantart.com");
		lblAboutDialogBackground.setHorizontalAlignment(SwingConstants.CENTER);
		lblAboutDialogBackground.setForeground(Color.WHITE);
		lblAboutDialogBackground.setBounds(10, 109, 480, 16);
		getContentPane().add(lblAboutDialogBackground);
		
		JLabel lblMainWindowBackground = new JLabel("Main window background: adamburn.deviantart.com");
		lblMainWindowBackground.setHorizontalAlignment(SwingConstants.CENTER);
		lblMainWindowBackground.setBounds(10, 137, 480, 16);
		lblMainWindowBackground.setForeground(Color.WHITE);
		getContentPane().add(lblMainWindowBackground);
		
		pack();
		getContentPane().add(backgroundLabel);
		
	}
	
	private BufferedImage texturedButtonTexture(int x, int y, int width, int height, String text){
		BufferedImage bf = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
		Graphics2D g2 = (Graphics2D) bf.getGraphics();
		g2.drawImage(BuilderLogGui.resizeImage(background, 500, 300).getSubimage(x, y, width, height), 0, 0, width, height, null);
		g2.setColor(Color.BLACK);
		g2.drawLine(0, 0, 0, height);
		g2.setColor(Color.WHITE);
		g2.drawString(text, 2, height / 2 + 5);
		return bf;
	}
}
