package theGhastModding.midiVideoGen.midi;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import theGhastModding.midiVideoGen.main.MidiToVideo;

public class MIDILoader {
	
	private List<Track> tracks;
	private int type = 0;
	private int trackCount;
	private int TPB;
	private long lengthInTicks;
	private long notecount;
	public static double multiplier = 1;
	private boolean largePiano;
	private boolean pagefile;
	
	//public static long tickLimit = Long.MAX_VALUE;
	
	public MIDILoader(File f, boolean largePiano, boolean pagefile, MidiToVideo m2v) throws Exception {
		this(new FileInputStream(f), largePiano, pagefile, m2v);
	}
	
	public MIDILoader(FileInputStream stream, boolean largePiano, boolean pagefile, MidiToVideo m2v) throws Exception {
		this.largePiano = largePiano;
		this.pagefile = pagefile;
		loadMidi(stream, m2v);
	}
	
	private void loadMidi(FileInputStream stream, MidiToVideo m2v) throws Exception {
		if(pagefile) {
			File pagefilesFolder = new File("pagefiles/");
			if(!pagefilesFolder.exists()){
				pagefilesFolder.mkdir();
			}
		}
		tracks = new ArrayList<Track>();
		byte[] indentifier = new byte[4];
		stream.read(indentifier);
		String s = new String(indentifier);
		if(!s.equals("MThd")){
			throw new Exception("Invalid file header: " + s);
		}
		indentifier = null;
		s = null;
		byte[] headerSize = new byte[4];
		stream.read(headerSize);
		int size = bytesToInt(headerSize);
		s = null;
		headerSize = null;
		byte[] header = new byte[size];
		stream.read(header);
		type = bytesToInt(Arrays.copyOfRange(header, 0, 2));
		trackCount = bytesToInt(Arrays.copyOfRange(header, 2, 4));
		TPB  = (int) (bytesToInt(Arrays.copyOfRange(header, 4, 6)) * multiplier);
		long[] lengths = new long[trackCount];
		for(int i = 0; i < trackCount; i++){
			System.out.println("Loading track " + i + " out of " + trackCount);
			m2v.status = "Loading track " + i + " out of " + trackCount;
			m2v.progress = (double)i / (double)trackCount * 1000D;
			Track t = new Track(largePiano);
			boolean b = false;
			if(!pagefile) {
				b = t.loadTrack(stream);
			}else {
				FileOutputStream fos = new FileOutputStream("pagefiles/pagefile_events_track_" + i + ".dat");
				b = t.loadTrackToPagefile(stream, fos, largePiano);
				fos.close();
			}
			lengths[i] = t.getLengthInTicks();
			notecount += t.getNotecount();
			if(!b){
				return;
			}
			tracks.add(t);
		}
		lengthInTicks = 0;
		for(long l:lengths){
			if(l > lengthInTicks){
				lengthInTicks = l;
			}
		}
		System.out.println(notecount);
		stream.close();
	}
	
	public long getLengthInTicks(){
		return lengthInTicks;
	}
	
	public void unload(){
		for(Track t:tracks){
			t.unload();
		}
	}
	
	private int bytesToInt(byte[] lol){
	    int value = 0;
	    for (int i = 0; i < lol.length; i++) {
	        int shift = (lol.length - 1 - i) * 8;
	        value += (lol[i] & 0x000000FF) << shift;
	    }
	    return value;
	}
	
	public int getType(){
		return type;
	}
	
	public int getTrackCount(){
		return trackCount;
	}
	
	public List<Track> getTracks(){
		return tracks;
	}
	
	public int getTPB(){
		return TPB;
	}
	
	public long getNoteCount(){
		return notecount;
	}
	
}
