package theGhastModding.midiConverter.midi;

public abstract class MIDIEvent {
	
	private long tick;
	private int size;
	private long delta;
	
	public MIDIEvent(long tick, int size, long delta){
		this.tick = tick;
		this.size = size;
		this.delta = delta;
	}
	
	public int getEventSize(){
		return size;
	}
	
	public int getDataSize(){
		return size + Track.toVaribaleLengthValue(delta).length;
	}
	
	public long getTick(){
		return tick;
	}
	
	public long getDelta(){
		return delta;
	}
	
}
