package theGhastModding.midiConverter.midi;

public class Note extends MIDIEvent {
	
	private double start;
	private double end;
	private int pitch;
	private int track;
	private int velocity;
	private int channel;
	
	public Note(double start, double end, int pitch, int track, int velocity, int channel) {
		super((long) start, 10, 0);
		this.start = start;
		this.end = end;
		this.pitch = pitch;
		this.track = track;
		this.velocity = velocity;
		this.channel = channel;
	}
	
	public int getTrack(){
		return track;
	}
	
	public double getStart() {
		return start;
	}
	
	public double getEnd() {
		return end;
	}
	
	public int getPitch() {
		return pitch;
	}
	
	public void setStart(double start) {
		this.start = start;
	}
	
	public void setEnd(double end) {
		this.end = end;
	}
	
	public void setPitch(int pitch) {
		this.pitch = pitch;
	}
	
	public void setTrack(int track) {
		this.track = track;
	}
	
	public int getVelocity() {
		return velocity;
	}
	
	public void setVelocity(int velocity) {
		this.velocity = velocity;
	}
	
	public int getChannel() {
		return channel;
	}
	
	public void setChannel(int channel) {
		this.channel = channel;
	}
	
}