package theGhastModding.tgmidi.main;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;

public class Settings {
	
	private int volume;
	private int voiceLimit;
	private int renderingLimit;
	private int audioFrequency;
	private boolean disableFx;
	private boolean noteOff;
	
	public Settings(int volume, int voiceLimit, int renderingLimit, int audioFrequency, boolean disableFx, boolean noteOff) {
		super();
		this.volume = volume;
		this.voiceLimit = voiceLimit;
		this.renderingLimit = renderingLimit;
		this.audioFrequency = audioFrequency;
		this.disableFx = disableFx;
		this.noteOff = noteOff;
	}
	
	public int getVolume() {
		return volume;
	}
	
	public int getVoiceLimit() {
		return voiceLimit;
	}
	
	public int getRenderingLimit() {
		return renderingLimit;
	}
	
	public int getAudioFrequency() {
		return audioFrequency;
	}
	
	public boolean isDisableFx() {
		return disableFx;
	}
	
	public boolean isNoteOff() {
		return noteOff;
	}
	
	public void setVolume(int volume) {
		this.volume = volume;
	}
	
	public void setVoiceLimit(int voiceLimit) {
		this.voiceLimit = voiceLimit;
	}
	
	public void setRenderingLimit(int renderingLimit) {
		this.renderingLimit = renderingLimit;
	}
	
	public void setAudioFrequency(int audioFrequency) {
		this.audioFrequency = audioFrequency;
	}
	
	public void setDisableFx(boolean disableFx) {
		this.disableFx = disableFx;
	}
	
	public void setNoteOff(boolean noteOff) {
		this.noteOff = noteOff;
	}
	
	public static List<Soundfont> loadSoundfonts() throws Exception {
		File location = new File(System.getenv("appdata") + "\\TGMIDI\\soundfonts.dat");
		List<Soundfont> soundfonts = new ArrayList<Soundfont>();
		if(!location.exists()){
			return soundfonts;
		}
		DataInputStream dis = new DataInputStream(new FileInputStream(location));
		int sfCount = dis.readInt();
		if(sfCount == 0){
			dis.close();
			return soundfonts;
		}
		String sfLocation;
		boolean sfEnabled;
		for(int i = 0; i < sfCount; i++){
			sfLocation = dis.readUTF();
			sfEnabled = dis.readBoolean();
			soundfonts.add(new Soundfont(new File(sfLocation), sfEnabled));
		}
		dis.close();
		return soundfonts;
	}
	
	public static void saveSoundfonts(List<Soundfont> soundfonts) throws Exception {
		File location = new File(System.getenv("appdata") + "\\TGMIDI\\soundfonts.dat");
		DataOutputStream dos = new DataOutputStream(new FileOutputStream(location));
		dos.writeInt(soundfonts.size());
		for(Soundfont sf:soundfonts){
			dos.writeUTF(sf.getLocation().getPath());
			dos.writeBoolean(sf.isEnabled());
		}
		dos.close();
	}
	
	public static Settings loadSettings() throws Exception {
		File location = new File(System.getenv("appdata") + "\\TGMIDI\\settings.dat");
		if(!location.exists()){
			return new Settings(100,500,0,44100,false,false);
		}
		DataInputStream dis = new DataInputStream(new FileInputStream(location));
		int audio = dis.readInt();
		int rLimit = dis.readInt();
		int vol = dis.readInt();
		int vLimit = dis.readInt();
		boolean dFx = dis.readBoolean();
		boolean isNO = dis.readBoolean();
		dis.close();
		return new Settings(vol, vLimit, rLimit, audio, dFx, isNO);
	}
	
	public static void saveSettings(Settings settings) throws Exception {
		File location = new File(System.getenv("appdata") + "\\TGMIDI\\settings.dat");
		DataOutputStream dos = new DataOutputStream(new FileOutputStream(location));
		dos.writeInt(settings.getAudioFrequency());
		dos.writeInt(settings.getRenderingLimit());
		dos.writeInt(settings.getVolume());
		dos.writeInt(settings.getVoiceLimit());
		dos.writeBoolean(settings.isDisableFx());
		dos.writeBoolean(settings.isNoteOff());
		dos.close();
	}
	
}