package theGhastModding.library.midi;

import java.io.File;
import java.io.FileNotFoundException;

public class Demo {
	
	/*
	 * Loads a MIDI, then moves all notes a tick forward and saves to a new file
	 */
	public static void demoProgram(String midiFilePath, String outputFilePath) throws Exception {
		File midiFile = new File(midiFilePath);
		if(!midiFile.exists()) throw new FileNotFoundException();
		//Arguments: input file
		//Note: will load instantly upon creation
		MIDILoader loader = new MIDILoader(midiFile);
		//loop through tracks
		for(int i = 0; i < loader.getTrackCount(); i++){
			//loop through all events in current track
			for(MIDIEvent e:loader.getTracks().get(i).getEvents()){
				//Move notes
				if(e instanceof NoteOn || e instanceof NoteOff){
					e.setTick(e.getTick() + 1);
				}
			}
		}
		File outputFile = new File(outputFilePath);
		//Saving is W.I.P! Be carefull with it!
		//Arguments for midi saver: output file path, tracks containing events to save, TPB (PPQ, ticks per beat/pulses per quarter note)
		//Note: will save instantly upon creation
		MIDISaver saver = new MIDISaver(outputFile, loader.getTracks(), loader.getTPB());
		saver.cleanUp();
		//Done
	}
	
}