package theGhastModding.library.midi;

import java.util.List;

public class InsertionSort {
	
	public static List<Integer> insertionSort(List<Integer> list) {
		int temp;
		for (int i = 1; i < list.size(); i++) {
			temp = list.get(i);
			int j = i;
			while (j > 0 && list.get(j - 1) > temp) {
				list.set(j, list.get(j - 1));
				j--;
			}
			list.set(j, temp);
		}
		return list;
	}
	
	public static List<MIDIEvent> sortByTickTGMMIDIEvents(List<MIDIEvent> list){
		MIDIEvent event;
		for (int i = 1; i < list.size(); i++) {
			event = list.get(i);
			int j = i;
			while (j > 0 && list.get(j - 1).getTick() > event.getTick()) {
				list.set(j, list.get(j - 1));
				j--;
			}
			list.set(j, event);
		}
		return list;
	}
	
	public static List<TempoEvent> sortByTickTGMTempos(List<TempoEvent> list){
		TempoEvent event;
		for (int i = 1; i < list.size(); i++) {
			event = list.get(i);
			int j = i;
			while (j > 0 && list.get(j - 1).getTick() > event.getTick()) {
				list.set(j, list.get(j - 1));
				j--;
			}
			list.set(j, event);
		}
		return list;
	}
	
}