package theGhastModding.library.midi;

public abstract class MIDIEvent {
	
	private long tick;
	private boolean isMeta;
	private byte signature;
	private int size;
	private long delta;
	
	public MIDIEvent(long tick, boolean isMeta, byte signature, int size, long delta){
		this.tick = tick * MIDILoader.multiplier;
		this.isMeta = isMeta;
		this.signature = signature;
		this.size = size;
		this.delta = delta;
	}
	
	public long getTick(){
		return tick;
	}
	
	public boolean getIsMeta(){
		return isMeta;
	}
	
	public byte getSignature(){
		return signature;
	}
	
	public int getSize(){
		return size;
	}
	
	public void setDelta(long delta){
		this.delta = delta;
	}
	
	public long getDelta(){
		return delta;
	}
	
	public void setTick(long tick){
		this.tick = tick;
	}
	
	public String toString(){
		return "Tick=" + Long.toString(tick) + ", Is meta=" + Boolean.toString(isMeta) + ", ID=" + Integer.toHexString(signature) + ", Size in bytes=" + Integer.toString(size);
	}
	
}
