package theGhastModding.library.midi;

public class NoteOn extends MIDIEvent{
	
	private int noteValue;
	private int velocity;
	private int channel;
	
	public NoteOn(long tick, int noteValue, int velocity, int channel, long delta){
		super(tick, false, (byte)(0x90 + channel), 3, delta);
		this.noteValue = noteValue;
		this.velocity = velocity;
		this.channel = channel;
	}
	
	public int getNoteValue(){
		return noteValue;
	}
	
	public void setNoteValue(int val){
		this.noteValue = val;
	}
	
	public int getVelocity(){
		return velocity;
	}
	
	public void setVelocity(int vel){
		this.velocity = vel;
	}
	
	public int getChannel(){
		return channel;
	}
	
	public void setChannel(int chan){
		this.channel = chan;
	}
	
}
