package theGhastModding.library.midi;

public class TempoEvent extends MIDIEvent {
	
	private float bpm;
	private int mpqn;
	private boolean used;
	
	public TempoEvent(long tick, float bpm, int mpqn, long delta){
		super(tick, true, (byte)0x51, 6, delta);
		this.bpm = bpm;
		this.mpqn = mpqn;
		used = false;
	}
	
	public float getBpm(){
		return bpm;
	}
	
	public void setBpm(float bpm){
		this.bpm = bpm;
		this.mpqn = (int) (60000000.0f / bpm);
	}
	
	public int getMpqn(){
		return mpqn;
	}
	
	public void setMpqn(int mpqn){
		this.mpqn = mpqn;
		this.bpm = 60000000.0F / mpqn;
	}
	
	public boolean isUsed(){
		return used;
	}
	
	public void setUsed(boolean used){
		this.used = used;
	}
	
}
