package theGhastModding.midiToolbox.main;

import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;

public class TGMMIDIToolbox {
	
	public static JFrame frame;
	public static String NAME = "TheGhastModding's MIDI toolbox";
	public static String VERSION = "1.0.3";
	
	public static void main(String[] args){
		try {
	        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		}catch(Exception e){
			e.printStackTrace();
		}
		frame = new JFrame(NAME);
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.setResizable(false);
		frame.setPreferredSize(new Dimension(700, 300));
		JTabbedPane tabbedPane = new JTabbedPane();
		tabbedPane.addTab("MIDI Information", new NoteCounterPanel());
		tabbedPane.addTab("MIDI Track Splitter", new TrackSplitterPanel());
		tabbedPane.addTab("Image to noteart", new ImageToNoteartPanel());
		tabbedPane.addTab("Message to binary notes", new BinaryMessageCreatorPanel());
		//tabbedPane.addTab("Login", new LoginPanel());
		tabbedPane.addTab("About", new AboutPanel());
		
		frame.add(tabbedPane);
		frame.pack();
		frame.setVisible(true);
	}
}