package theGhastModding.midiPlayerGL.main;

import javax.swing.JOptionPane;
import javax.swing.UIManager;

import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWVidMode;
import theGhastModding.midiPlayerGL.gui.MainWindow;
import theGhastModding.midiPlayerGL.midi.MIDILoader;

public class TGMPGLMain {
	
	public static final String NAME = "TGMP, but with GPU rendering";
	public static final String VERSION = "a_11242017";
	
	public static void main(String[] args) {
		try {
	        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		}catch(Exception e){
			e.printStackTrace();
		}
		int cores = Runtime.getRuntime().availableProcessors();
		int res = JOptionPane.showConfirmDialog(null, "The Java VM has determined that your CPU has " + Integer.toString(cores) + " thread" + (cores > 1 ? "s" : "") + ". Is this correct? (Press 'YES' if you're not sure)", "Confirm cores", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE);
		if(res == 1){
			String input = JOptionPane.showInputDialog(null, "In this case, please enter the correct number of threads below.", "Enter number of cores", JOptionPane.INFORMATION_MESSAGE);
			try {
				cores = Integer.parseInt(input);
				if(cores < 0){
					JOptionPane.showMessageDialog(null, "Veeeery funny.", "...", JOptionPane.ERROR_MESSAGE);
					System.exit(1);
				}
			}catch(Exception e){
				JOptionPane.showMessageDialog(null, "Error: " + e.getMessage() + ". You may have entered something that wasn't a number.", "Error", JOptionPane.ERROR_MESSAGE);
				e.printStackTrace();
				System.exit(1);
			}
		}
		if(cores > 128) cores = 128;
		if(!GLFW.glfwInit()){
			JOptionPane.showMessageDialog(null, "Error initializing GLFW", "Error", JOptionPane.ERROR_MESSAGE);
			return;
		}
		
		long window = GLFW.glfwCreateWindow(1280, 720, NAME, 0, 0);
		if(window == 0){
			JOptionPane.showMessageDialog(null, "Error creating window", "Error", JOptionPane.ERROR_MESSAGE);
			return;
		}
		
		GLFWVidMode videoMode = GLFW.glfwGetVideoMode(GLFW.glfwGetPrimaryMonitor());
		GLFW.glfwSetWindowPos(window, (videoMode.width() - 1280) / 2, (videoMode.height() - 720) / 2);
		GLFW.glfwWindowHint(GLFW.GLFW_SAMPLES, 4);
		GLFW.glfwShowWindow(window);
		
		GLFW.glfwSetInputMode(window, GLFW.GLFW_CURSOR, GLFW.GLFW_CURSOR_DISABLED);
		
		MIDILoader.multiplier = Integer.parseInt(args[1]);
		MainWindow mw = new MainWindow(window, args[0], cores);
		mw.run();
	}
	
}