package theGhastModding.midiPlayerGL.models;

import theGhastModding.midiPlayerGL.midi.Note;

public class NoteModel {
	
	public static final float noteWidth = 1.0f / 64.0f;
	
	private RawModel model;
	private int key;
	private float yPos;
	private int track;
	private float length;
	private Note note;
	
	public NoteModel(RawModel model, int key, float yPos, int track, float length, Note note) {
		super();
		this.model = model;
		this.key = key;
		this.yPos = yPos;
		this.track = track;
		this.length = length;
		this.note = note;
	}
	
	public RawModel getModel() {
		return model;
	}
	
	public int getKey() {
		return key;
	}
	
	public float getYPos() {
		return yPos;
	}
	
	public int getTrack() {
		return track;
	}
	
	public float getLength() {
		return length;
	}
	
	public Note getNote() {
		return note;
	}
	
	public void increaseY(float inc) {
		this.yPos -= inc;
	}
	
	public void setY(float y) {
		this.yPos = y;
	}
	
}