package theGhastModding.midiPlayerGL.models;

import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL30;

public class RawModel {
	
	private int vaoID;
	private int[] vboIDs;
	private int vertexCount;
	
	public RawModel(int vaoID, int vertexCount, int[] vboIDs) {
		this.vaoID = vaoID;
		this.vertexCount = vertexCount;
		this.vboIDs = vboIDs;
	}
	
	public int getVaoID() {
		return vaoID;
	}
	
	public int getVertexCount() {
		return vertexCount;
	}
	
	public int[] getVboIDs() {
		return vboIDs;
	}
	
	public void delete() {
		GL30.glDeleteVertexArrays(vaoID);
		for(int vbo:vboIDs) {
			GL15.glDeleteBuffers(vbo);
		}
	}
	
}