package theGhastModding.midiPlayerGL.shaders;

import org.joml.Vector2f;
import org.joml.Vector3f;

public class NoteShader extends ShaderProgram {
	
	private static final String VERTEX = "/vertex.txt";
	private static final String FRAGMENT = "/fragment.txt";
	
	private int location_baseColor;
	private int location_pos;
	
	public NoteShader() {
		super(VERTEX, FRAGMENT);
	}
	
	@Override
	protected void bindAttributes() {
		super.bindAttribute(0, "position");
	}
	
	@Override
	protected void getAllUniformLocations() {
		location_baseColor = super.getUniformLocation("baseColor");
		location_pos = super.getUniformLocation("pos");
		
	}
	
	public void setPosition(Vector2f pos) {
		super.loadVector2f(location_pos, pos);
	}
	
	public void setBaseColor(Vector3f color) {
		super.loadVector3f(location_baseColor, color);
	}
	
}