package theGhastModding.midiPlayerGL.shaders;

import org.joml.Vector2f;
import org.joml.Vector3f;

public class TextShader extends ShaderProgram {
	
	private static final String VERTEX_FILE = "/textVertex.txt";
	private static final String FRAGMENT_FILE = "/textFragment.txt";
	
	private int location_color;
	private int location_translation;
	
	public TextShader() {
		super(VERTEX_FILE, FRAGMENT_FILE);
	}
	
	@Override
	protected void getAllUniformLocations() {
		location_color = super.getUniformLocation("color");
		location_translation = super.getUniformLocation("translation");
	}
	
	@Override
	protected void bindAttributes() {
		super.bindAttribute(0, "position");
		super.bindAttribute(1, "textureCoords");
	}
	
	public void loadColor(Vector3f color){
		super.loadVector3f(location_color, color);
	}
	
	public void loadTranslation(Vector2f translation){
		super.loadVector2f(location_translation, translation);
	}
	
}