package theGhastModding.tgmsynth.synth;

public class Note {
	
	private float status = 0;
	private int key;
	private int velocity;
	private float cycleLength;
	private float upStrength;
	private int channel;
	
	public Note(int key, int velocity, int channel) {
		super();
		this.key = key;
		this.velocity = velocity;
		cycleLength = (float) (1000D / (Math.pow(2, ((double)key - 69D) / 12D) * 440D));
		upStrength = (float) ((double)velocity / 127D * 2000D);
		this.channel = channel;
	}
	
	public float getStatus() {
		return status;
	}
	
	public int getChannel(){
		return channel;
	}
	
	public void setStatus(float status) {
		this.status = status;
	}
	
	public int getKey() {
		return key;
	}
	
	public int getVelocity() {
		return velocity;
	}
	
	public float getCycleLength() {
		return cycleLength;
	}
	
	public float getUpStrength() {
		return upStrength;
	}
	
	public float getDownStrength(){
		return -upStrength;
	}
	
	public boolean equals(Object o){
		if(o instanceof Note){
			if(((Note)o).getKey() == this.key && ((Note)o).getChannel() == this.channel){
				return true;
			}
			return false;
		}else{
			return false;
		}
	}
	
}