package theGhastModding.midiEditor.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.border.BevelBorder;
import javax.swing.border.LineBorder;
import javax.swing.filechooser.FileNameExtensionFilter;

import theGhastModding.midiEditor.main.MIDIEditorStart;
import theGhastModding.midiEditor.midi.MIDIFile;

@SuppressWarnings("serial")
public class MIDIEditorPanel extends JPanel implements Runnable {
	
	private JFileChooser midiChooser;
	private Menu fileMenu;
	public static long frameWidth;
	private MIDIFile midi;
	private Thread t;
	private JScrollBar scrollBar;
	private JLabel lblMeminfo;
	
	public MIDIEditorPanel(){
		super();
		System.out.println("Inititalizing Panel");
		this.setPreferredSize(new Dimension(1280, 720));
		this.setLayout(null);
		
		System.out.println("Creating components");
		JLabel lblVersion = new JLabel("VERSION");
		if(MIDIEditorStart.VERSION.startsWith("Development")){
			lblVersion.setText(MIDIEditorStart.VERSION);
		}else{
			lblVersion.setText("");
		}
		lblVersion.setBounds(10, 11, 138, 14);
		add(lblVersion);
		
		JPanel panel = new JPanel();
		panel.setBorder(new LineBorder(new Color(0, 0, 0)));
		panel.setBackground(Color.WHITE);
		panel.setBounds(10, 171, 1260, 426);
		frameWidth = panel.getWidth();
		add(panel);
		
		scrollBar = new JScrollBar();
		scrollBar.setBorder(new BevelBorder(BevelBorder.LOWERED, null, null, null, null));
		scrollBar.setOrientation(JScrollBar.HORIZONTAL);
		scrollBar.setBounds(10, 608, 1260, 17);
		add(scrollBar);
		
		lblMeminfo = new JLabel("");
		lblMeminfo.setBounds(983, 695, 287, 14);
		add(lblMeminfo);
		
		midiChooser = new JFileChooser();
		midiChooser.setFileFilter(new FileNameExtensionFilter("MIDIs", "mid", "MID", "midi", "MIDI"));
		
		System.out.println("Creating Menu bar");
		MenuBar menuBar = new MenuBar();
		MIDIEditorStart.frame.setMenuBar(menuBar);
		fileMenu = new Menu("File");
		menuBar.add(fileMenu);
		MenuItem loadItem = new MenuItem("Load MIDI");
		fileMenu.add(loadItem);
		loadItem.addActionListener(new ActionListener(){
			@Override
			public void actionPerformed(ActionEvent arg0) {
				if(midiChooser.showOpenDialog(MIDIEditorStart.frame) == JFileChooser.APPROVE_OPTION){
					if(!midiChooser.getSelectedFile().exists()){
						JOptionPane.showMessageDialog(MIDIEditorStart.frame, "The selected MIDI file doesn't exist", "Error", JOptionPane.ERROR_MESSAGE);
						return;
					}
					fileMenu.setEnabled(false);
					midi = new MIDIFile(midiChooser.getSelectedFile().getPath());
				}
			}
		});
		JFileChooser exportChooser = new JFileChooser();
		exportChooser.setFileFilter(new FileNameExtensionFilter("MIDIs", "mid", "MID", "midi", "MIDI"));
		MenuItem exportItem = new MenuItem("Export as MIDI");
		exportItem.addActionListener(new ActionListener(){
			@Override
			public void actionPerformed(ActionEvent arg0) {
				if(exportChooser.showOpenDialog(MIDIEditorStart.frame) == JFileChooser.APPROVE_OPTION){
					if(exportChooser.getSelectedFile().exists()){
						int option = JOptionPane.showConfirmDialog(MIDIEditorStart.frame, "The selected file allready exists. Replace?", "File exists", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE);
						if(option != 0){
							return;
						}
					}
					midi.save(exportChooser.getSelectedFile());
				}
			}
		});
		fileMenu.add(exportItem);
		MenuItem exitItem = new MenuItem("Exit");
		fileMenu.add(exitItem);
		exitItem.addActionListener(new ActionListener(){
			@Override
			public void actionPerformed(ActionEvent arg0) {
				System.exit(0);
			}
		});
		
		System.out.println("Starting thread");
		t = new Thread(this);
		runtime = Runtime.getRuntime();
		t.start();
	}
	
	private Runtime runtime;
	
	@Override
	public void run(){
		long debugTimer = System.currentTimeMillis() + 1000L;
		while(true){
			/*if(midi != null && !midi.hasLoadSucceded() && !midi.isLoading()){
				midi = null;
			}*/
			if(midi != null && !midi.isLoading() && !fileMenu.isEnabled() && midi.hasLoadSucceded()){
				fileMenu.setEnabled(true);
				scrollBar.setValue(0);
				scrollBar.setMaximum((int)midi.getMidiLength());
			}
			if(System.currentTimeMillis() - debugTimer >= 1000){
				debugTimer = System.currentTimeMillis();
				long maxMemory = runtime.maxMemory();
				long allocatedMemory = runtime.totalMemory();
				long freeMemory = runtime.freeMemory();
				lblMeminfo.setText("Currently using " + Long.toString((allocatedMemory - freeMemory) / 1024 / 1024) + "MB out of " + Long.toString(maxMemory / 1024 / 1024) + "MB (" + Long.toString(allocatedMemory / 1024 / 1024) + "MB allocated)");
			}
			try {
				Thread.sleep(1);
			}catch(Exception e){
				e.printStackTrace();
			}
		}
	}
}