package theGhastModding.midiEditor.gui;

import java.awt.Dimension;

import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingConstants;

import theGhastModding.midiEditor.main.MIDIEditorStart;

@SuppressWarnings("serial")
public class ProgressDialog extends JDialog implements Runnable {
	
	public static int progress;
	public static String status;
	private JProgressBar progressBar;
	private JLabel lblLoadingStatus;
	private boolean running = false;
	private Thread t;
	
	private ProgressDialog(String title){
		super(MIDIEditorStart.frame, title);
		//setModal(true);
		setLocationRelativeTo(MIDIEditorStart.frame);
		this.setResizable(false);
		this.getContentPane().setLayout(null);
		this.getContentPane().setPreferredSize(new Dimension(700,60));
		
		progressBar = new JProgressBar();
		progressBar.setBounds(10, 36, 680, 16);
		getContentPane().add(progressBar);
		
		lblLoadingStatus = new JLabel("Starting to load MIDI...");
		lblLoadingStatus.setHorizontalAlignment(SwingConstants.CENTER);
		lblLoadingStatus.setBounds(10, 11, 680, 14);
		getContentPane().add(lblLoadingStatus);
		this.setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
		progressBar.setMinimum(0);
		progressBar.setMaximum(100);
		
		pack();
		setVisible(true);
	}
	
	public static ProgressDialog showLoadDialog(String title){
		ProgressDialog dialog = new ProgressDialog(title);
		ProgressDialog.status = "Starting to load MIDI...";
		ProgressDialog.progress = 0;
		dialog.start();
		return dialog;
	}
	
	public void close(){
		running = false;
		try {
			t.join();
		} catch(Exception e){
			e.printStackTrace();
		}
	}
	
	private void start(){
		t = new Thread(this);
		t.start();
	}
	
	@Override
	public void run() {
		running = true;
		while(running){
			lblLoadingStatus.setText(status);
			if(progress > 100){
				progress = 100;
			}
			progressBar.setValue(progress);
			try {
				Thread.sleep(157);
			}catch(Exception e){
				e.printStackTrace();
			}
		}
		setVisible(false);
		dispose();
	}
	
}